package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PSParameterName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteParametersRequest(names: Iterable[PSParameterName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteParametersRequest = {
    import DeleteParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteParametersRequest
      .builder()
      .names(names.map { item =>
        PSParameterName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteParametersRequest.ReadOnly =
    zio.aws.ssm.model.DeleteParametersRequest.wrap(buildAwsValue())
}
object DeleteParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteParametersRequest =
      zio.aws.ssm.model.DeleteParametersRequest(names)
    def names: List[PSParameterName]
    def getNames: ZIO[Any, Nothing, List[PSParameterName]] = ZIO.succeed(names)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteParametersRequest
  ) extends zio.aws.ssm.model.DeleteParametersRequest.ReadOnly {
    override val names: List[PSParameterName] = impl
      .names()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.PSParameterName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteParametersRequest
  ): zio.aws.ssm.model.DeleteParametersRequest.ReadOnly = new Wrapper(impl)
}
