package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AttributeValue,
  AttributeName,
  OpsEntityItemCaptureTime
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OpsEntityItem(
    captureTime: Option[OpsEntityItemCaptureTime] = None,
    content: Option[Iterable[Map[AttributeName, AttributeValue]]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsEntityItem = {
    import OpsEntityItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsEntityItem
      .builder()
      .optionallyWith(
        captureTime.map(value =>
          OpsEntityItemCaptureTime.unwrap(value): java.lang.String
        )
      )(_.captureTime)
      .optionallyWith(
        content.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                  .unwrap(value): java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.content)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsEntityItem.ReadOnly =
    zio.aws.ssm.model.OpsEntityItem.wrap(buildAwsValue())
}
object OpsEntityItem {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsEntityItem] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsEntityItem =
      zio.aws.ssm.model.OpsEntityItem(
        captureTime.map(value => value),
        content.map(value => value)
      )
    def captureTime: Option[OpsEntityItemCaptureTime]
    def content: Option[List[Map[AttributeName, AttributeValue]]]
    def getCaptureTime: ZIO[Any, AwsError, OpsEntityItemCaptureTime] =
      AwsError.unwrapOptionField("captureTime", captureTime)
    def getContent
        : ZIO[Any, AwsError, List[Map[AttributeName, AttributeValue]]] =
      AwsError.unwrapOptionField("content", content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsEntityItem
  ) extends zio.aws.ssm.model.OpsEntityItem.ReadOnly {
    override val captureTime: Option[OpsEntityItemCaptureTime] = scala
      .Option(impl.captureTime())
      .map(value =>
        zio.aws.ssm.model.primitives.OpsEntityItemCaptureTime(value)
      )
    override val content: Option[List[Map[AttributeName, AttributeValue]]] =
      scala
        .Option(impl.content())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.ssm.model.primitives.AttributeName(
                  key
                ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
              })
              .toMap
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsEntityItem
  ): zio.aws.ssm.model.OpsEntityItem.ReadOnly = new Wrapper(impl)
}
