package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait NotificationType {
  def unwrap: software.amazon.awssdk.services.ssm.model.NotificationType
}
object NotificationType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.NotificationType
  ): zio.aws.ssm.model.NotificationType = value match {
    case software.amazon.awssdk.services.ssm.model.NotificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.NotificationType.COMMAND =>
      val r = Command
      r
    case software.amazon.awssdk.services.ssm.model.NotificationType.INVOCATION =>
      val r = Invocation
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationType =
      software.amazon.awssdk.services.ssm.model.NotificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object Command extends zio.aws.ssm.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationType =
      software.amazon.awssdk.services.ssm.model.NotificationType.COMMAND
  }
  case object Invocation extends zio.aws.ssm.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.NotificationType =
      software.amazon.awssdk.services.ssm.model.NotificationType.INVOCATION
  }
}
