package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  IamRole,
  StatusName,
  InstanceId,
  SourceId,
  ActivationId,
  DateTime,
  ComputerName,
  Version,
  IPAddress
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class InstanceInformation(
    instanceId: Option[InstanceId] = None,
    pingStatus: Option[zio.aws.ssm.model.PingStatus] = None,
    lastPingDateTime: Option[DateTime] = None,
    agentVersion: Option[Version] = None,
    isLatestVersion: Option[Boolean] = None,
    platformType: Option[zio.aws.ssm.model.PlatformType] = None,
    platformName: Option[String] = None,
    platformVersion: Option[String] = None,
    activationId: Option[ActivationId] = None,
    iamRole: Option[IamRole] = None,
    registrationDate: Option[DateTime] = None,
    resourceType: Option[zio.aws.ssm.model.ResourceType] = None,
    name: Option[String] = None,
    ipAddress: Option[IPAddress] = None,
    computerName: Option[ComputerName] = None,
    associationStatus: Option[StatusName] = None,
    lastAssociationExecutionDate: Option[DateTime] = None,
    lastSuccessfulAssociationExecutionDate: Option[DateTime] = None,
    associationOverview: Option[
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview
    ] = None,
    sourceId: Option[SourceId] = None,
    sourceType: Option[zio.aws.ssm.model.SourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceInformation = {
    import InstanceInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceInformation
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(pingStatus.map(value => value.unwrap))(_.pingStatus)
      .optionallyWith(
        lastPingDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastPingDateTime)
      .optionallyWith(
        agentVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.agentVersion)
      .optionallyWith(isLatestVersion.map(value => value: java.lang.Boolean))(
        _.isLatestVersion
      )
      .optionallyWith(platformType.map(value => value.unwrap))(_.platformType)
      .optionallyWith(platformName.map(value => value: java.lang.String))(
        _.platformName
      )
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(
        activationId.map(value => ActivationId.unwrap(value): java.lang.String)
      )(_.activationId)
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        registrationDate.map(value => DateTime.unwrap(value): Instant)
      )(_.registrationDate)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        computerName.map(value => ComputerName.unwrap(value): java.lang.String)
      )(_.computerName)
      .optionallyWith(
        associationStatus.map(value =>
          StatusName.unwrap(value): java.lang.String
        )
      )(_.associationStatus)
      .optionallyWith(
        lastAssociationExecutionDate.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.lastAssociationExecutionDate)
      .optionallyWith(
        lastSuccessfulAssociationExecutionDate.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.lastSuccessfulAssociationExecutionDate)
      .optionallyWith(associationOverview.map(value => value.buildAwsValue()))(
        _.associationOverview
      )
      .optionallyWith(
        sourceId.map(value => SourceId.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceInformation.ReadOnly =
    zio.aws.ssm.model.InstanceInformation.wrap(buildAwsValue())
}
object InstanceInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceInformation =
      zio.aws.ssm.model.InstanceInformation(
        instanceId.map(value => value),
        pingStatus.map(value => value),
        lastPingDateTime.map(value => value),
        agentVersion.map(value => value),
        isLatestVersion.map(value => value),
        platformType.map(value => value),
        platformName.map(value => value),
        platformVersion.map(value => value),
        activationId.map(value => value),
        iamRole.map(value => value),
        registrationDate.map(value => value),
        resourceType.map(value => value),
        name.map(value => value),
        ipAddress.map(value => value),
        computerName.map(value => value),
        associationStatus.map(value => value),
        lastAssociationExecutionDate.map(value => value),
        lastSuccessfulAssociationExecutionDate.map(value => value),
        associationOverview.map(value => value.asEditable),
        sourceId.map(value => value),
        sourceType.map(value => value)
      )
    def instanceId: Option[InstanceId]
    def pingStatus: Option[zio.aws.ssm.model.PingStatus]
    def lastPingDateTime: Option[DateTime]
    def agentVersion: Option[Version]
    def isLatestVersion: Option[Boolean]
    def platformType: Option[zio.aws.ssm.model.PlatformType]
    def platformName: Option[String]
    def platformVersion: Option[String]
    def activationId: Option[ActivationId]
    def iamRole: Option[IamRole]
    def registrationDate: Option[DateTime]
    def resourceType: Option[zio.aws.ssm.model.ResourceType]
    def name: Option[String]
    def ipAddress: Option[IPAddress]
    def computerName: Option[ComputerName]
    def associationStatus: Option[StatusName]
    def lastAssociationExecutionDate: Option[DateTime]
    def lastSuccessfulAssociationExecutionDate: Option[DateTime]
    def associationOverview: Option[
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly
    ]
    def sourceId: Option[SourceId]
    def sourceType: Option[zio.aws.ssm.model.SourceType]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPingStatus: ZIO[Any, AwsError, zio.aws.ssm.model.PingStatus] =
      AwsError.unwrapOptionField("pingStatus", pingStatus)
    def getLastPingDateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastPingDateTime", lastPingDateTime)
    def getAgentVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
    def getIsLatestVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isLatestVersion", isLatestVersion)
    def getPlatformType: ZIO[Any, AwsError, zio.aws.ssm.model.PlatformType] =
      AwsError.unwrapOptionField("platformType", platformType)
    def getPlatformName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformName", platformName)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getActivationId: ZIO[Any, AwsError, ActivationId] =
      AwsError.unwrapOptionField("activationId", activationId)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getRegistrationDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("registrationDate", registrationDate)
    def getResourceType: ZIO[Any, AwsError, zio.aws.ssm.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getComputerName: ZIO[Any, AwsError, ComputerName] =
      AwsError.unwrapOptionField("computerName", computerName)
    def getAssociationStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("associationStatus", associationStatus)
    def getLastAssociationExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField(
        "lastAssociationExecutionDate",
        lastAssociationExecutionDate
      )
    def getLastSuccessfulAssociationExecutionDate
        : ZIO[Any, AwsError, DateTime] = AwsError.unwrapOptionField(
      "lastSuccessfulAssociationExecutionDate",
      lastSuccessfulAssociationExecutionDate
    )
    def getAssociationOverview: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly
    ] = AwsError.unwrapOptionField("associationOverview", associationOverview)
    def getSourceId: ZIO[Any, AwsError, SourceId] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getSourceType: ZIO[Any, AwsError, zio.aws.ssm.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceInformation
  ) extends zio.aws.ssm.model.InstanceInformation.ReadOnly {
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val pingStatus: Option[zio.aws.ssm.model.PingStatus] = scala
      .Option(impl.pingStatus())
      .map(value => zio.aws.ssm.model.PingStatus.wrap(value))
    override val lastPingDateTime: Option[DateTime] = scala
      .Option(impl.lastPingDateTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val agentVersion: Option[Version] = scala
      .Option(impl.agentVersion())
      .map(value => zio.aws.ssm.model.primitives.Version(value))
    override val isLatestVersion: Option[Boolean] =
      scala.Option(impl.isLatestVersion()).map(value => value: Boolean)
    override val platformType: Option[zio.aws.ssm.model.PlatformType] = scala
      .Option(impl.platformType())
      .map(value => zio.aws.ssm.model.PlatformType.wrap(value))
    override val platformName: Option[String] =
      scala.Option(impl.platformName()).map(value => value: String)
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val activationId: Option[ActivationId] = scala
      .Option(impl.activationId())
      .map(value => zio.aws.ssm.model.primitives.ActivationId(value))
    override val iamRole: Option[IamRole] = scala
      .Option(impl.iamRole())
      .map(value => zio.aws.ssm.model.primitives.IamRole(value))
    override val registrationDate: Option[DateTime] = scala
      .Option(impl.registrationDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val resourceType: Option[zio.aws.ssm.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.ssm.model.ResourceType.wrap(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val ipAddress: Option[IPAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.ssm.model.primitives.IPAddress(value))
    override val computerName: Option[ComputerName] = scala
      .Option(impl.computerName())
      .map(value => zio.aws.ssm.model.primitives.ComputerName(value))
    override val associationStatus: Option[StatusName] = scala
      .Option(impl.associationStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val lastAssociationExecutionDate: Option[DateTime] = scala
      .Option(impl.lastAssociationExecutionDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastSuccessfulAssociationExecutionDate: Option[DateTime] =
      scala
        .Option(impl.lastSuccessfulAssociationExecutionDate())
        .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val associationOverview: Option[
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly
    ] = scala
      .Option(impl.associationOverview())
      .map(value =>
        zio.aws.ssm.model.InstanceAggregatedAssociationOverview.wrap(value)
      )
    override val sourceId: Option[SourceId] = scala
      .Option(impl.sourceId())
      .map(value => zio.aws.ssm.model.primitives.SourceId(value))
    override val sourceType: Option[zio.aws.ssm.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.ssm.model.SourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceInformation
  ): zio.aws.ssm.model.InstanceInformation.ReadOnly = new Wrapper(impl)
}
