package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AssociationVersion,
  DocumentContent,
  InstanceId,
  AssociationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceAssociation(
    associationId: Option[AssociationId] = None,
    instanceId: Option[InstanceId] = None,
    content: Option[DocumentContent] = None,
    associationVersion: Option[AssociationVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceAssociation = {
    import InstanceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceAssociation
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        content.map(value => DocumentContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceAssociation.ReadOnly =
    zio.aws.ssm.model.InstanceAssociation.wrap(buildAwsValue())
}
object InstanceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceAssociation =
      zio.aws.ssm.model.InstanceAssociation(
        associationId.map(value => value),
        instanceId.map(value => value),
        content.map(value => value),
        associationVersion.map(value => value)
      )
    def associationId: Option[AssociationId]
    def instanceId: Option[InstanceId]
    def content: Option[DocumentContent]
    def associationVersion: Option[AssociationVersion]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getContent: ZIO[Any, AwsError, DocumentContent] =
      AwsError.unwrapOptionField("content", content)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociation
  ) extends zio.aws.ssm.model.InstanceAssociation.ReadOnly {
    override val associationId: Option[AssociationId] = scala
      .Option(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val content: Option[DocumentContent] = scala
      .Option(impl.content())
      .map(value => zio.aws.ssm.model.primitives.DocumentContent(value))
    override val associationVersion: Option[AssociationVersion] = scala
      .Option(impl.associationVersion())
      .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociation
  ): zio.aws.ssm.model.InstanceAssociation.ReadOnly = new Wrapper(impl)
}
