package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  Comment,
  StringDateTime,
  DocumentName,
  Url,
  InstanceId,
  CommandId,
  DocumentVersion,
  StandardOutputContent,
  ResponseCode,
  CommandPluginName,
  StandardErrorContent,
  StatusDetails
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCommandInvocationResponse(
    commandId: Option[CommandId] = None,
    instanceId: Option[InstanceId] = None,
    comment: Option[Comment] = None,
    documentName: Option[DocumentName] = None,
    documentVersion: Option[DocumentVersion] = None,
    pluginName: Option[CommandPluginName] = None,
    responseCode: Option[ResponseCode] = None,
    executionStartDateTime: Option[StringDateTime] = None,
    executionElapsedTime: Option[StringDateTime] = None,
    executionEndDateTime: Option[StringDateTime] = None,
    status: Option[zio.aws.ssm.model.CommandInvocationStatus] = None,
    statusDetails: Option[StatusDetails] = None,
    standardOutputContent: Option[StandardOutputContent] = None,
    standardOutputUrl: Option[Url] = None,
    standardErrorContent: Option[StandardErrorContent] = None,
    standardErrorUrl: Option[Url] = None,
    cloudWatchOutputConfig: Option[zio.aws.ssm.model.CloudWatchOutputConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse = {
    import GetCommandInvocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse
      .builder()
      .optionallyWith(
        commandId.map(value => CommandId.unwrap(value): java.lang.String)
      )(_.commandId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        pluginName.map(value =>
          CommandPluginName.unwrap(value): java.lang.String
        )
      )(_.pluginName)
      .optionallyWith(
        responseCode.map(value => ResponseCode.unwrap(value): Integer)
      )(_.responseCode)
      .optionallyWith(
        executionStartDateTime.map(value =>
          StringDateTime.unwrap(value): java.lang.String
        )
      )(_.executionStartDateTime)
      .optionallyWith(
        executionElapsedTime.map(value =>
          StringDateTime.unwrap(value): java.lang.String
        )
      )(_.executionElapsedTime)
      .optionallyWith(
        executionEndDateTime.map(value =>
          StringDateTime.unwrap(value): java.lang.String
        )
      )(_.executionEndDateTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          StatusDetails.unwrap(value): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(
        standardOutputContent.map(value =>
          StandardOutputContent.unwrap(value): java.lang.String
        )
      )(_.standardOutputContent)
      .optionallyWith(
        standardOutputUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardOutputUrl)
      .optionallyWith(
        standardErrorContent.map(value =>
          StandardErrorContent.unwrap(value): java.lang.String
        )
      )(_.standardErrorContent)
      .optionallyWith(
        standardErrorUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardErrorUrl)
      .optionallyWith(
        cloudWatchOutputConfig.map(value => value.buildAwsValue())
      )(_.cloudWatchOutputConfig)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly =
    zio.aws.ssm.model.GetCommandInvocationResponse.wrap(buildAwsValue())
}
object GetCommandInvocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetCommandInvocationResponse =
      zio.aws.ssm.model.GetCommandInvocationResponse(
        commandId.map(value => value),
        instanceId.map(value => value),
        comment.map(value => value),
        documentName.map(value => value),
        documentVersion.map(value => value),
        pluginName.map(value => value),
        responseCode.map(value => value),
        executionStartDateTime.map(value => value),
        executionElapsedTime.map(value => value),
        executionEndDateTime.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        standardOutputContent.map(value => value),
        standardOutputUrl.map(value => value),
        standardErrorContent.map(value => value),
        standardErrorUrl.map(value => value),
        cloudWatchOutputConfig.map(value => value.asEditable)
      )
    def commandId: Option[CommandId]
    def instanceId: Option[InstanceId]
    def comment: Option[Comment]
    def documentName: Option[DocumentName]
    def documentVersion: Option[DocumentVersion]
    def pluginName: Option[CommandPluginName]
    def responseCode: Option[ResponseCode]
    def executionStartDateTime: Option[StringDateTime]
    def executionElapsedTime: Option[StringDateTime]
    def executionEndDateTime: Option[StringDateTime]
    def status: Option[zio.aws.ssm.model.CommandInvocationStatus]
    def statusDetails: Option[StatusDetails]
    def standardOutputContent: Option[StandardOutputContent]
    def standardOutputUrl: Option[Url]
    def standardErrorContent: Option[StandardErrorContent]
    def standardErrorUrl: Option[Url]
    def cloudWatchOutputConfig
        : Option[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly]
    def getCommandId: ZIO[Any, AwsError, CommandId] =
      AwsError.unwrapOptionField("commandId", commandId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getPluginName: ZIO[Any, AwsError, CommandPluginName] =
      AwsError.unwrapOptionField("pluginName", pluginName)
    def getResponseCode: ZIO[Any, AwsError, ResponseCode] =
      AwsError.unwrapOptionField("responseCode", responseCode)
    def getExecutionStartDateTime: ZIO[Any, AwsError, StringDateTime] = AwsError
      .unwrapOptionField("executionStartDateTime", executionStartDateTime)
    def getExecutionElapsedTime: ZIO[Any, AwsError, StringDateTime] =
      AwsError.unwrapOptionField("executionElapsedTime", executionElapsedTime)
    def getExecutionEndDateTime: ZIO[Any, AwsError, StringDateTime] =
      AwsError.unwrapOptionField("executionEndDateTime", executionEndDateTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.CommandInvocationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, StatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStandardOutputContent: ZIO[Any, AwsError, StandardOutputContent] =
      AwsError.unwrapOptionField("standardOutputContent", standardOutputContent)
    def getStandardOutputUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardOutputUrl", standardOutputUrl)
    def getStandardErrorContent: ZIO[Any, AwsError, StandardErrorContent] =
      AwsError.unwrapOptionField("standardErrorContent", standardErrorContent)
    def getStandardErrorUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardErrorUrl", standardErrorUrl)
    def getCloudWatchOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchOutputConfig",
      cloudWatchOutputConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse
  ) extends zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly {
    override val commandId: Option[CommandId] = scala
      .Option(impl.commandId())
      .map(value => zio.aws.ssm.model.primitives.CommandId(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val comment: Option[Comment] = scala
      .Option(impl.comment())
      .map(value => zio.aws.ssm.model.primitives.Comment(value))
    override val documentName: Option[DocumentName] = scala
      .Option(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val pluginName: Option[CommandPluginName] = scala
      .Option(impl.pluginName())
      .map(value => zio.aws.ssm.model.primitives.CommandPluginName(value))
    override val responseCode: Option[ResponseCode] = scala
      .Option(impl.responseCode())
      .map(value => zio.aws.ssm.model.primitives.ResponseCode(value))
    override val executionStartDateTime: Option[StringDateTime] = scala
      .Option(impl.executionStartDateTime())
      .map(value => zio.aws.ssm.model.primitives.StringDateTime(value))
    override val executionElapsedTime: Option[StringDateTime] = scala
      .Option(impl.executionElapsedTime())
      .map(value => zio.aws.ssm.model.primitives.StringDateTime(value))
    override val executionEndDateTime: Option[StringDateTime] = scala
      .Option(impl.executionEndDateTime())
      .map(value => zio.aws.ssm.model.primitives.StringDateTime(value))
    override val status: Option[zio.aws.ssm.model.CommandInvocationStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ssm.model.CommandInvocationStatus.wrap(value))
    override val statusDetails: Option[StatusDetails] = scala
      .Option(impl.statusDetails())
      .map(value => zio.aws.ssm.model.primitives.StatusDetails(value))
    override val standardOutputContent: Option[StandardOutputContent] = scala
      .Option(impl.standardOutputContent())
      .map(value => zio.aws.ssm.model.primitives.StandardOutputContent(value))
    override val standardOutputUrl: Option[Url] = scala
      .Option(impl.standardOutputUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val standardErrorContent: Option[StandardErrorContent] = scala
      .Option(impl.standardErrorContent())
      .map(value => zio.aws.ssm.model.primitives.StandardErrorContent(value))
    override val standardErrorUrl: Option[Url] = scala
      .Option(impl.standardErrorUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val cloudWatchOutputConfig
        : Option[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly] = scala
      .Option(impl.cloudWatchOutputConfig())
      .map(value => zio.aws.ssm.model.CloudWatchOutputConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse
  ): zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly = new Wrapper(impl)
}
