package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ResourceDataSyncAWSKMSKeyARN,
  ResourceDataSyncS3Region,
  ResourceDataSyncS3Prefix,
  ResourceDataSyncS3BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceDataSyncS3Destination(
    bucketName: ResourceDataSyncS3BucketName,
    prefix: Option[ResourceDataSyncS3Prefix] = None,
    syncFormat: zio.aws.ssm.model.ResourceDataSyncS3Format,
    region: ResourceDataSyncS3Region,
    awskmsKeyARN: Option[ResourceDataSyncAWSKMSKeyARN] = None,
    destinationDataSharing: Option[
      zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination = {
    import ResourceDataSyncS3Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination
      .builder()
      .bucketName(
        ResourceDataSyncS3BucketName.unwrap(bucketName): java.lang.String
      )
      .optionallyWith(
        prefix.map(value =>
          ResourceDataSyncS3Prefix.unwrap(value): java.lang.String
        )
      )(_.prefix)
      .syncFormat(syncFormat.unwrap)
      .region(ResourceDataSyncS3Region.unwrap(region): java.lang.String)
      .optionallyWith(
        awskmsKeyARN.map(value =>
          ResourceDataSyncAWSKMSKeyARN.unwrap(value): java.lang.String
        )
      )(_.awskmsKeyARN)
      .optionallyWith(
        destinationDataSharing.map(value => value.buildAwsValue())
      )(_.destinationDataSharing)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResourceDataSyncS3Destination.ReadOnly =
    zio.aws.ssm.model.ResourceDataSyncS3Destination.wrap(buildAwsValue())
}
object ResourceDataSyncS3Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResourceDataSyncS3Destination =
      zio.aws.ssm.model.ResourceDataSyncS3Destination(
        bucketName,
        prefix.map(value => value),
        syncFormat,
        region,
        awskmsKeyARN.map(value => value),
        destinationDataSharing.map(value => value.asEditable)
      )
    def bucketName: ResourceDataSyncS3BucketName
    def prefix: Option[ResourceDataSyncS3Prefix]
    def syncFormat: zio.aws.ssm.model.ResourceDataSyncS3Format
    def region: ResourceDataSyncS3Region
    def awskmsKeyARN: Option[ResourceDataSyncAWSKMSKeyARN]
    def destinationDataSharing: Option[
      zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing.ReadOnly
    ]
    def getBucketName: ZIO[Any, Nothing, ResourceDataSyncS3BucketName] =
      ZIO.succeed(bucketName)
    def getPrefix: ZIO[Any, AwsError, ResourceDataSyncS3Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getSyncFormat
        : ZIO[Any, Nothing, zio.aws.ssm.model.ResourceDataSyncS3Format] =
      ZIO.succeed(syncFormat)
    def getRegion: ZIO[Any, Nothing, ResourceDataSyncS3Region] =
      ZIO.succeed(region)
    def getAwskmsKeyARN: ZIO[Any, AwsError, ResourceDataSyncAWSKMSKeyARN] =
      AwsError.unwrapOptionField("awskmsKeyARN", awskmsKeyARN)
    def getDestinationDataSharing: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationDataSharing",
      destinationDataSharing
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination
  ) extends zio.aws.ssm.model.ResourceDataSyncS3Destination.ReadOnly {
    override val bucketName: ResourceDataSyncS3BucketName =
      zio.aws.ssm.model.primitives
        .ResourceDataSyncS3BucketName(impl.bucketName())
    override val prefix: Option[ResourceDataSyncS3Prefix] = scala
      .Option(impl.prefix())
      .map(value =>
        zio.aws.ssm.model.primitives.ResourceDataSyncS3Prefix(value)
      )
    override val syncFormat: zio.aws.ssm.model.ResourceDataSyncS3Format =
      zio.aws.ssm.model.ResourceDataSyncS3Format.wrap(impl.syncFormat())
    override val region: ResourceDataSyncS3Region =
      zio.aws.ssm.model.primitives.ResourceDataSyncS3Region(impl.region())
    override val awskmsKeyARN: Option[ResourceDataSyncAWSKMSKeyARN] = scala
      .Option(impl.awskmsKeyARN())
      .map(value =>
        zio.aws.ssm.model.primitives.ResourceDataSyncAWSKMSKeyARN(value)
      )
    override val destinationDataSharing: Option[
      zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing.ReadOnly
    ] = scala
      .Option(impl.destinationDataSharing())
      .map(value =>
        zio.aws.ssm.model.ResourceDataSyncDestinationDataSharing.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination
  ): zio.aws.ssm.model.ResourceDataSyncS3Destination.ReadOnly = new Wrapper(
    impl
  )
}
