package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ComplianceResourceId,
  ComplianceResourceType,
  ComplianceTypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceComplianceSummaryItem(
    complianceType: Option[ComplianceTypeName] = None,
    resourceType: Option[ComplianceResourceType] = None,
    resourceId: Option[ComplianceResourceId] = None,
    status: Option[zio.aws.ssm.model.ComplianceStatus] = None,
    overallSeverity: Option[zio.aws.ssm.model.ComplianceSeverity] = None,
    executionSummary: Option[zio.aws.ssm.model.ComplianceExecutionSummary] =
      None,
    compliantSummary: Option[zio.aws.ssm.model.CompliantSummary] = None,
    nonCompliantSummary: Option[zio.aws.ssm.model.NonCompliantSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem = {
    import ResourceComplianceSummaryItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem
      .builder()
      .optionallyWith(
        complianceType.map(value =>
          ComplianceTypeName.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(
        resourceType.map(value =>
          ComplianceResourceType.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          ComplianceResourceId.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(overallSeverity.map(value => value.unwrap))(
        _.overallSeverity
      )
      .optionallyWith(executionSummary.map(value => value.buildAwsValue()))(
        _.executionSummary
      )
      .optionallyWith(compliantSummary.map(value => value.buildAwsValue()))(
        _.compliantSummary
      )
      .optionallyWith(nonCompliantSummary.map(value => value.buildAwsValue()))(
        _.nonCompliantSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly =
    zio.aws.ssm.model.ResourceComplianceSummaryItem.wrap(buildAwsValue())
}
object ResourceComplianceSummaryItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResourceComplianceSummaryItem =
      zio.aws.ssm.model.ResourceComplianceSummaryItem(
        complianceType.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        status.map(value => value),
        overallSeverity.map(value => value),
        executionSummary.map(value => value.asEditable),
        compliantSummary.map(value => value.asEditable),
        nonCompliantSummary.map(value => value.asEditable)
      )
    def complianceType: Option[ComplianceTypeName]
    def resourceType: Option[ComplianceResourceType]
    def resourceId: Option[ComplianceResourceId]
    def status: Option[zio.aws.ssm.model.ComplianceStatus]
    def overallSeverity: Option[zio.aws.ssm.model.ComplianceSeverity]
    def executionSummary
        : Option[zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly]
    def compliantSummary: Option[zio.aws.ssm.model.CompliantSummary.ReadOnly]
    def nonCompliantSummary
        : Option[zio.aws.ssm.model.NonCompliantSummary.ReadOnly]
    def getComplianceType: ZIO[Any, AwsError, ComplianceTypeName] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getResourceType: ZIO[Any, AwsError, ComplianceResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ComplianceResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ComplianceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOverallSeverity
        : ZIO[Any, AwsError, zio.aws.ssm.model.ComplianceSeverity] =
      AwsError.unwrapOptionField("overallSeverity", overallSeverity)
    def getExecutionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("executionSummary", executionSummary)
    def getCompliantSummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.CompliantSummary.ReadOnly] =
      AwsError.unwrapOptionField("compliantSummary", compliantSummary)
    def getNonCompliantSummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.NonCompliantSummary.ReadOnly] =
      AwsError.unwrapOptionField("nonCompliantSummary", nonCompliantSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem
  ) extends zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly {
    override val complianceType: Option[ComplianceTypeName] = scala
      .Option(impl.complianceType())
      .map(value => zio.aws.ssm.model.primitives.ComplianceTypeName(value))
    override val resourceType: Option[ComplianceResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.ssm.model.primitives.ComplianceResourceType(value))
    override val resourceId: Option[ComplianceResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.ssm.model.primitives.ComplianceResourceId(value))
    override val status: Option[zio.aws.ssm.model.ComplianceStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.ComplianceStatus.wrap(value))
    override val overallSeverity: Option[zio.aws.ssm.model.ComplianceSeverity] =
      scala
        .Option(impl.overallSeverity())
        .map(value => zio.aws.ssm.model.ComplianceSeverity.wrap(value))
    override val executionSummary
        : Option[zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly] = scala
      .Option(impl.executionSummary())
      .map(value => zio.aws.ssm.model.ComplianceExecutionSummary.wrap(value))
    override val compliantSummary
        : Option[zio.aws.ssm.model.CompliantSummary.ReadOnly] = scala
      .Option(impl.compliantSummary())
      .map(value => zio.aws.ssm.model.CompliantSummary.wrap(value))
    override val nonCompliantSummary
        : Option[zio.aws.ssm.model.NonCompliantSummary.ReadOnly] = scala
      .Option(impl.nonCompliantSummary())
      .map(value => zio.aws.ssm.model.NonCompliantSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem
  ): zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly = new Wrapper(
    impl
  )
}
