package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemEventMaxResults
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListOpsItemEventsRequest(
    filters: Option[Iterable[zio.aws.ssm.model.OpsItemEventFilter]] = None,
    maxResults: Option[OpsItemEventMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest = {
    import ListOpsItemEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => OpsItemEventMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListOpsItemEventsRequest.ReadOnly =
    zio.aws.ssm.model.ListOpsItemEventsRequest.wrap(buildAwsValue())
}
object ListOpsItemEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListOpsItemEventsRequest =
      zio.aws.ssm.model.ListOpsItemEventsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Option[List[zio.aws.ssm.model.OpsItemEventFilter.ReadOnly]]
    def maxResults: Option[OpsItemEventMaxResults]
    def nextToken: Option[String]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemEventFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, OpsItemEventMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest
  ) extends zio.aws.ssm.model.ListOpsItemEventsRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.ssm.model.OpsItemEventFilter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsItemEventFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[OpsItemEventMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.OpsItemEventMaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest
  ): zio.aws.ssm.model.ListOpsItemEventsRequest.ReadOnly = new Wrapper(impl)
}
