package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeMaintenanceWindowsForTargetResponse(
    windowIdentities: Option[
      Iterable[zio.aws.ssm.model.MaintenanceWindowIdentityForTarget]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse = {
    import DescribeMaintenanceWindowsForTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse
      .builder()
      .optionallyWith(
        windowIdentities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.windowIdentities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowsForTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse =
      zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse(
        windowIdentities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def windowIdentities: Option[
      List[zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getWindowIdentities: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("windowIdentities", windowIdentities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse.ReadOnly {
    override val windowIdentities: Option[
      List[zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly]
    ] = scala
      .Option(impl.windowIdentities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse
  ): zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse.ReadOnly =
    new Wrapper(impl)
}
