package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstancePatchStatesResponse(
    instancePatchStates: Option[
      Iterable[zio.aws.ssm.model.InstancePatchState]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse = {
    import DescribeInstancePatchStatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse
      .builder()
      .optionallyWith(
        instancePatchStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instancePatchStates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstancePatchStatesResponse.ReadOnly =
    zio.aws.ssm.model.DescribeInstancePatchStatesResponse.wrap(buildAwsValue())
}
object DescribeInstancePatchStatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInstancePatchStatesResponse =
      zio.aws.ssm.model.DescribeInstancePatchStatesResponse(
        instancePatchStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instancePatchStates
        : Option[List[zio.aws.ssm.model.InstancePatchState.ReadOnly]]
    def nextToken: Option[NextToken]
    def getInstancePatchStates: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstancePatchState.ReadOnly
    ]] = AwsError.unwrapOptionField("instancePatchStates", instancePatchStates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse
  ) extends zio.aws.ssm.model.DescribeInstancePatchStatesResponse.ReadOnly {
    override val instancePatchStates
        : Option[List[zio.aws.ssm.model.InstancePatchState.ReadOnly]] = scala
      .Option(impl.instancePatchStates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InstancePatchState.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse
  ): zio.aws.ssm.model.DescribeInstancePatchStatesResponse.ReadOnly =
    new Wrapper(impl)
}
