package zio.aws.ssm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  Url,
  S3Region,
  CommandPluginOutput,
  S3KeyPrefix,
  ResponseCode,
  DateTime,
  S3BucketName,
  CommandPluginName,
  StatusDetails
}
import scala.jdk.CollectionConverters._
final case class CommandPlugin(
    name: Option[CommandPluginName] = None,
    status: Option[zio.aws.ssm.model.CommandPluginStatus] = None,
    statusDetails: Option[StatusDetails] = None,
    responseCode: Option[ResponseCode] = None,
    responseStartDateTime: Option[DateTime] = None,
    responseFinishDateTime: Option[DateTime] = None,
    output: Option[CommandPluginOutput] = None,
    standardOutputUrl: Option[Url] = None,
    standardErrorUrl: Option[Url] = None,
    outputS3Region: Option[S3Region] = None,
    outputS3BucketName: Option[S3BucketName] = None,
    outputS3KeyPrefix: Option[S3KeyPrefix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CommandPlugin = {
    import CommandPlugin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CommandPlugin
      .builder()
      .optionallyWith(
        name.map(value => CommandPluginName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          StatusDetails.unwrap(value): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(
        responseCode.map(value => ResponseCode.unwrap(value): Integer)
      )(_.responseCode)
      .optionallyWith(
        responseStartDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.responseStartDateTime)
      .optionallyWith(
        responseFinishDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.responseFinishDateTime)
      .optionallyWith(
        output.map(value => CommandPluginOutput.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(
        standardOutputUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardOutputUrl)
      .optionallyWith(
        standardErrorUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardErrorUrl)
      .optionallyWith(
        outputS3Region.map(value => S3Region.unwrap(value): java.lang.String)
      )(_.outputS3Region)
      .optionallyWith(
        outputS3BucketName.map(value =>
          S3BucketName.unwrap(value): java.lang.String
        )
      )(_.outputS3BucketName)
      .optionallyWith(
        outputS3KeyPrefix.map(value =>
          S3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.outputS3KeyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CommandPlugin.ReadOnly =
    zio.aws.ssm.model.CommandPlugin.wrap(buildAwsValue())
}
object CommandPlugin {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.CommandPlugin] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CommandPlugin =
      zio.aws.ssm.model.CommandPlugin(
        name.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        responseCode.map(value => value),
        responseStartDateTime.map(value => value),
        responseFinishDateTime.map(value => value),
        output.map(value => value),
        standardOutputUrl.map(value => value),
        standardErrorUrl.map(value => value),
        outputS3Region.map(value => value),
        outputS3BucketName.map(value => value),
        outputS3KeyPrefix.map(value => value)
      )
    def name: Option[CommandPluginName]
    def status: Option[zio.aws.ssm.model.CommandPluginStatus]
    def statusDetails: Option[StatusDetails]
    def responseCode: Option[ResponseCode]
    def responseStartDateTime: Option[DateTime]
    def responseFinishDateTime: Option[DateTime]
    def output: Option[CommandPluginOutput]
    def standardOutputUrl: Option[Url]
    def standardErrorUrl: Option[Url]
    def outputS3Region: Option[S3Region]
    def outputS3BucketName: Option[S3BucketName]
    def outputS3KeyPrefix: Option[S3KeyPrefix]
    def getName: ZIO[Any, AwsError, CommandPluginName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.CommandPluginStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, StatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getResponseCode: ZIO[Any, AwsError, ResponseCode] =
      AwsError.unwrapOptionField("responseCode", responseCode)
    def getResponseStartDateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("responseStartDateTime", responseStartDateTime)
    def getResponseFinishDateTime: ZIO[Any, AwsError, DateTime] = AwsError
      .unwrapOptionField("responseFinishDateTime", responseFinishDateTime)
    def getOutput: ZIO[Any, AwsError, CommandPluginOutput] =
      AwsError.unwrapOptionField("output", output)
    def getStandardOutputUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardOutputUrl", standardOutputUrl)
    def getStandardErrorUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardErrorUrl", standardErrorUrl)
    def getOutputS3Region: ZIO[Any, AwsError, S3Region] =
      AwsError.unwrapOptionField("outputS3Region", outputS3Region)
    def getOutputS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("outputS3BucketName", outputS3BucketName)
    def getOutputS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("outputS3KeyPrefix", outputS3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CommandPlugin
  ) extends zio.aws.ssm.model.CommandPlugin.ReadOnly {
    override val name: Option[CommandPluginName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.CommandPluginName(value))
    override val status: Option[zio.aws.ssm.model.CommandPluginStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.CommandPluginStatus.wrap(value))
    override val statusDetails: Option[StatusDetails] = scala
      .Option(impl.statusDetails())
      .map(value => zio.aws.ssm.model.primitives.StatusDetails(value))
    override val responseCode: Option[ResponseCode] = scala
      .Option(impl.responseCode())
      .map(value => zio.aws.ssm.model.primitives.ResponseCode(value))
    override val responseStartDateTime: Option[DateTime] = scala
      .Option(impl.responseStartDateTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val responseFinishDateTime: Option[DateTime] = scala
      .Option(impl.responseFinishDateTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val output: Option[CommandPluginOutput] = scala
      .Option(impl.output())
      .map(value => zio.aws.ssm.model.primitives.CommandPluginOutput(value))
    override val standardOutputUrl: Option[Url] = scala
      .Option(impl.standardOutputUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val standardErrorUrl: Option[Url] = scala
      .Option(impl.standardErrorUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val outputS3Region: Option[S3Region] = scala
      .Option(impl.outputS3Region())
      .map(value => zio.aws.ssm.model.primitives.S3Region(value))
    override val outputS3BucketName: Option[S3BucketName] = scala
      .Option(impl.outputS3BucketName())
      .map(value => zio.aws.ssm.model.primitives.S3BucketName(value))
    override val outputS3KeyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.outputS3KeyPrefix())
      .map(value => zio.aws.ssm.model.primitives.S3KeyPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CommandPlugin
  ): zio.aws.ssm.model.CommandPlugin.ReadOnly = new Wrapper(impl)
}
