package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  Comment,
  DocumentName,
  Url,
  InstanceId,
  CommandId,
  DocumentVersion,
  DateTime,
  InvocationTraceOutput,
  ServiceRole,
  InstanceTagName,
  StatusDetails
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CommandInvocation(
    commandId: Option[CommandId] = None,
    instanceId: Option[InstanceId] = None,
    instanceName: Option[InstanceTagName] = None,
    comment: Option[Comment] = None,
    documentName: Option[DocumentName] = None,
    documentVersion: Option[DocumentVersion] = None,
    requestedDateTime: Option[DateTime] = None,
    status: Option[zio.aws.ssm.model.CommandInvocationStatus] = None,
    statusDetails: Option[StatusDetails] = None,
    traceOutput: Option[InvocationTraceOutput] = None,
    standardOutputUrl: Option[Url] = None,
    standardErrorUrl: Option[Url] = None,
    commandPlugins: Option[Iterable[zio.aws.ssm.model.CommandPlugin]] = None,
    serviceRole: Option[ServiceRole] = None,
    notificationConfig: Option[zio.aws.ssm.model.NotificationConfig] = None,
    cloudWatchOutputConfig: Option[zio.aws.ssm.model.CloudWatchOutputConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CommandInvocation = {
    import CommandInvocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CommandInvocation
      .builder()
      .optionallyWith(
        commandId.map(value => CommandId.unwrap(value): java.lang.String)
      )(_.commandId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        instanceName.map(value =>
          InstanceTagName.unwrap(value): java.lang.String
        )
      )(_.instanceName)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        requestedDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.requestedDateTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          StatusDetails.unwrap(value): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(
        traceOutput.map(value =>
          InvocationTraceOutput.unwrap(value): java.lang.String
        )
      )(_.traceOutput)
      .optionallyWith(
        standardOutputUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardOutputUrl)
      .optionallyWith(
        standardErrorUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardErrorUrl)
      .optionallyWith(
        commandPlugins.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commandPlugins)
      .optionallyWith(
        serviceRole.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(notificationConfig.map(value => value.buildAwsValue()))(
        _.notificationConfig
      )
      .optionallyWith(
        cloudWatchOutputConfig.map(value => value.buildAwsValue())
      )(_.cloudWatchOutputConfig)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CommandInvocation.ReadOnly =
    zio.aws.ssm.model.CommandInvocation.wrap(buildAwsValue())
}
object CommandInvocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CommandInvocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CommandInvocation =
      zio.aws.ssm.model.CommandInvocation(
        commandId.map(value => value),
        instanceId.map(value => value),
        instanceName.map(value => value),
        comment.map(value => value),
        documentName.map(value => value),
        documentVersion.map(value => value),
        requestedDateTime.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        traceOutput.map(value => value),
        standardOutputUrl.map(value => value),
        standardErrorUrl.map(value => value),
        commandPlugins.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceRole.map(value => value),
        notificationConfig.map(value => value.asEditable),
        cloudWatchOutputConfig.map(value => value.asEditable)
      )
    def commandId: Option[CommandId]
    def instanceId: Option[InstanceId]
    def instanceName: Option[InstanceTagName]
    def comment: Option[Comment]
    def documentName: Option[DocumentName]
    def documentVersion: Option[DocumentVersion]
    def requestedDateTime: Option[DateTime]
    def status: Option[zio.aws.ssm.model.CommandInvocationStatus]
    def statusDetails: Option[StatusDetails]
    def traceOutput: Option[InvocationTraceOutput]
    def standardOutputUrl: Option[Url]
    def standardErrorUrl: Option[Url]
    def commandPlugins: Option[List[zio.aws.ssm.model.CommandPlugin.ReadOnly]]
    def serviceRole: Option[ServiceRole]
    def notificationConfig
        : Option[zio.aws.ssm.model.NotificationConfig.ReadOnly]
    def cloudWatchOutputConfig
        : Option[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly]
    def getCommandId: ZIO[Any, AwsError, CommandId] =
      AwsError.unwrapOptionField("commandId", commandId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceName: ZIO[Any, AwsError, InstanceTagName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getRequestedDateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("requestedDateTime", requestedDateTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.CommandInvocationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, StatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getTraceOutput: ZIO[Any, AwsError, InvocationTraceOutput] =
      AwsError.unwrapOptionField("traceOutput", traceOutput)
    def getStandardOutputUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardOutputUrl", standardOutputUrl)
    def getStandardErrorUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardErrorUrl", standardErrorUrl)
    def getCommandPlugins
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.CommandPlugin.ReadOnly]] =
      AwsError.unwrapOptionField("commandPlugins", commandPlugins)
    def getServiceRole: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getNotificationConfig
        : ZIO[Any, AwsError, zio.aws.ssm.model.NotificationConfig.ReadOnly] =
      AwsError.unwrapOptionField("notificationConfig", notificationConfig)
    def getCloudWatchOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchOutputConfig",
      cloudWatchOutputConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CommandInvocation
  ) extends zio.aws.ssm.model.CommandInvocation.ReadOnly {
    override val commandId: Option[CommandId] = scala
      .Option(impl.commandId())
      .map(value => zio.aws.ssm.model.primitives.CommandId(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val instanceName: Option[InstanceTagName] = scala
      .Option(impl.instanceName())
      .map(value => zio.aws.ssm.model.primitives.InstanceTagName(value))
    override val comment: Option[Comment] = scala
      .Option(impl.comment())
      .map(value => zio.aws.ssm.model.primitives.Comment(value))
    override val documentName: Option[DocumentName] = scala
      .Option(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val requestedDateTime: Option[DateTime] = scala
      .Option(impl.requestedDateTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status: Option[zio.aws.ssm.model.CommandInvocationStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ssm.model.CommandInvocationStatus.wrap(value))
    override val statusDetails: Option[StatusDetails] = scala
      .Option(impl.statusDetails())
      .map(value => zio.aws.ssm.model.primitives.StatusDetails(value))
    override val traceOutput: Option[InvocationTraceOutput] = scala
      .Option(impl.traceOutput())
      .map(value => zio.aws.ssm.model.primitives.InvocationTraceOutput(value))
    override val standardOutputUrl: Option[Url] = scala
      .Option(impl.standardOutputUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val standardErrorUrl: Option[Url] = scala
      .Option(impl.standardErrorUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val commandPlugins
        : Option[List[zio.aws.ssm.model.CommandPlugin.ReadOnly]] = scala
      .Option(impl.commandPlugins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.CommandPlugin.wrap(item)
        }.toList
      )
    override val serviceRole: Option[ServiceRole] = scala
      .Option(impl.serviceRole())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val notificationConfig
        : Option[zio.aws.ssm.model.NotificationConfig.ReadOnly] = scala
      .Option(impl.notificationConfig())
      .map(value => zio.aws.ssm.model.NotificationConfig.wrap(value))
    override val cloudWatchOutputConfig
        : Option[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly] = scala
      .Option(impl.cloudWatchOutputConfig())
      .map(value => zio.aws.ssm.model.CloudWatchOutputConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CommandInvocation
  ): zio.aws.ssm.model.CommandInvocation.ReadOnly = new Wrapper(impl)
}
