package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PatchId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BaselineOverride(
    operatingSystem: Option[zio.aws.ssm.model.OperatingSystem] = None,
    globalFilters: Option[zio.aws.ssm.model.PatchFilterGroup] = None,
    approvalRules: Option[zio.aws.ssm.model.PatchRuleGroup] = None,
    approvedPatches: Option[Iterable[PatchId]] = None,
    approvedPatchesComplianceLevel: Option[
      zio.aws.ssm.model.PatchComplianceLevel
    ] = None,
    rejectedPatches: Option[Iterable[PatchId]] = None,
    rejectedPatchesAction: Option[zio.aws.ssm.model.PatchAction] = None,
    approvedPatchesEnableNonSecurity: Option[Boolean] = None,
    sources: Option[Iterable[zio.aws.ssm.model.PatchSource]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.BaselineOverride = {
    import BaselineOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.BaselineOverride
      .builder()
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(globalFilters.map(value => value.buildAwsValue()))(
        _.globalFilters
      )
      .optionallyWith(approvalRules.map(value => value.buildAwsValue()))(
        _.approvalRules
      )
      .optionallyWith(
        approvedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvedPatches)
      .optionallyWith(
        approvedPatchesComplianceLevel.map(value => value.unwrap)
      )(_.approvedPatchesComplianceLevel)
      .optionallyWith(
        rejectedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rejectedPatches)
      .optionallyWith(rejectedPatchesAction.map(value => value.unwrap))(
        _.rejectedPatchesAction
      )
      .optionallyWith(
        approvedPatchesEnableNonSecurity.map(value => value: java.lang.Boolean)
      )(_.approvedPatchesEnableNonSecurity)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.BaselineOverride.ReadOnly =
    zio.aws.ssm.model.BaselineOverride.wrap(buildAwsValue())
}
object BaselineOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.BaselineOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.BaselineOverride =
      zio.aws.ssm.model.BaselineOverride(
        operatingSystem.map(value => value),
        globalFilters.map(value => value.asEditable),
        approvalRules.map(value => value.asEditable),
        approvedPatches.map(value => value),
        approvedPatchesComplianceLevel.map(value => value),
        rejectedPatches.map(value => value),
        rejectedPatchesAction.map(value => value),
        approvedPatchesEnableNonSecurity.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def operatingSystem: Option[zio.aws.ssm.model.OperatingSystem]
    def globalFilters: Option[zio.aws.ssm.model.PatchFilterGroup.ReadOnly]
    def approvalRules: Option[zio.aws.ssm.model.PatchRuleGroup.ReadOnly]
    def approvedPatches: Option[List[PatchId]]
    def approvedPatchesComplianceLevel
        : Option[zio.aws.ssm.model.PatchComplianceLevel]
    def rejectedPatches: Option[List[PatchId]]
    def rejectedPatchesAction: Option[zio.aws.ssm.model.PatchAction]
    def approvedPatchesEnableNonSecurity: Option[Boolean]
    def sources: Option[List[zio.aws.ssm.model.PatchSource.ReadOnly]]
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.ssm.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getGlobalFilters
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      AwsError.unwrapOptionField("globalFilters", globalFilters)
    def getApprovalRules
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchRuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("approvalRules", approvalRules)
    def getApprovedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("approvedPatches", approvedPatches)
    def getApprovedPatchesComplianceLevel
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchComplianceLevel] =
      AwsError.unwrapOptionField(
        "approvedPatchesComplianceLevel",
        approvedPatchesComplianceLevel
      )
    def getRejectedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("rejectedPatches", rejectedPatches)
    def getRejectedPatchesAction
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchAction] =
      AwsError.unwrapOptionField("rejectedPatchesAction", rejectedPatchesAction)
    def getApprovedPatchesEnableNonSecurity: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "approvedPatchesEnableNonSecurity",
        approvedPatchesEnableNonSecurity
      )
    def getSources
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.BaselineOverride
  ) extends zio.aws.ssm.model.BaselineOverride.ReadOnly {
    override val operatingSystem: Option[zio.aws.ssm.model.OperatingSystem] =
      scala
        .Option(impl.operatingSystem())
        .map(value => zio.aws.ssm.model.OperatingSystem.wrap(value))
    override val globalFilters
        : Option[zio.aws.ssm.model.PatchFilterGroup.ReadOnly] = scala
      .Option(impl.globalFilters())
      .map(value => zio.aws.ssm.model.PatchFilterGroup.wrap(value))
    override val approvalRules
        : Option[zio.aws.ssm.model.PatchRuleGroup.ReadOnly] = scala
      .Option(impl.approvalRules())
      .map(value => zio.aws.ssm.model.PatchRuleGroup.wrap(value))
    override val approvedPatches: Option[List[PatchId]] = scala
      .Option(impl.approvedPatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.PatchId(item)
        }.toList
      )
    override val approvedPatchesComplianceLevel
        : Option[zio.aws.ssm.model.PatchComplianceLevel] = scala
      .Option(impl.approvedPatchesComplianceLevel())
      .map(value => zio.aws.ssm.model.PatchComplianceLevel.wrap(value))
    override val rejectedPatches: Option[List[PatchId]] = scala
      .Option(impl.rejectedPatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.PatchId(item)
        }.toList
      )
    override val rejectedPatchesAction: Option[zio.aws.ssm.model.PatchAction] =
      scala
        .Option(impl.rejectedPatchesAction())
        .map(value => zio.aws.ssm.model.PatchAction.wrap(value))
    override val approvedPatchesEnableNonSecurity: Option[Boolean] = scala
      .Option(impl.approvedPatchesEnableNonSecurity())
      .map(value => value: Boolean)
    override val sources: Option[List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      scala
        .Option(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchSource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.BaselineOverride
  ): zio.aws.ssm.model.BaselineOverride.ReadOnly = new Wrapper(impl)
}
