package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDocumentResponse(
    documentDescription: Option[zio.aws.ssm.model.DocumentDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse = {
    import UpdateDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse
      .builder()
      .optionallyWith(documentDescription.map(value => value.buildAwsValue()))(
        _.documentDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateDocumentResponse.ReadOnly =
    zio.aws.ssm.model.UpdateDocumentResponse.wrap(buildAwsValue())
}
object UpdateDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateDocumentResponse =
      zio.aws.ssm.model.UpdateDocumentResponse(
        documentDescription.map(value => value.asEditable)
      )
    def documentDescription
        : Option[zio.aws.ssm.model.DocumentDescription.ReadOnly]
    def getDocumentDescription
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentDescription.ReadOnly] =
      AwsError.unwrapOptionField("documentDescription", documentDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse
  ) extends zio.aws.ssm.model.UpdateDocumentResponse.ReadOnly {
    override val documentDescription
        : Option[zio.aws.ssm.model.DocumentDescription.ReadOnly] = scala
      .Option(impl.documentDescription())
      .map(value => zio.aws.ssm.model.DocumentDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse
  ): zio.aws.ssm.model.UpdateDocumentResponse.ReadOnly = new Wrapper(impl)
}
