package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ReviewStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.ReviewStatus
}
object ReviewStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ReviewStatus
  ): zio.aws.ssm.model.ReviewStatus = value match {
    case software.amazon.awssdk.services.ssm.model.ReviewStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ReviewStatus.APPROVED =>
      val r = APPROVED
      r
    case software.amazon.awssdk.services.ssm.model.ReviewStatus.NOT_REVIEWED =>
      val r = NOT_REVIEWED
      r
    case software.amazon.awssdk.services.ssm.model.ReviewStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.ssm.model.ReviewStatus.REJECTED =>
      val r = REJECTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ReviewStatus =
      software.amazon.awssdk.services.ssm.model.ReviewStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object APPROVED extends zio.aws.ssm.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ReviewStatus =
      software.amazon.awssdk.services.ssm.model.ReviewStatus.APPROVED
  }
  case object NOT_REVIEWED extends zio.aws.ssm.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ReviewStatus =
      software.amazon.awssdk.services.ssm.model.ReviewStatus.NOT_REVIEWED
  }
  case object PENDING extends zio.aws.ssm.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ReviewStatus =
      software.amazon.awssdk.services.ssm.model.ReviewStatus.PENDING
  }
  case object REJECTED extends zio.aws.ssm.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ReviewStatus =
      software.amazon.awssdk.services.ssm.model.ReviewStatus.REJECTED
  }
}
