package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.BaselineId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegisterDefaultPatchBaselineRequest(baselineId: BaselineId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest = {
    import RegisterDefaultPatchBaselineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest
      .builder()
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterDefaultPatchBaselineRequest.ReadOnly =
    zio.aws.ssm.model.RegisterDefaultPatchBaselineRequest.wrap(buildAwsValue())
}
object RegisterDefaultPatchBaselineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.RegisterDefaultPatchBaselineRequest =
      zio.aws.ssm.model.RegisterDefaultPatchBaselineRequest(baselineId)
    def baselineId: BaselineId
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest
  ) extends zio.aws.ssm.model.RegisterDefaultPatchBaselineRequest.ReadOnly {
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest
  ): zio.aws.ssm.model.RegisterDefaultPatchBaselineRequest.ReadOnly =
    new Wrapper(impl)
}
