package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PatchFilterGroup(
    patchFilters: Iterable[zio.aws.ssm.model.PatchFilter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PatchFilterGroup = {
    import PatchFilterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchFilterGroup
      .builder()
      .patchFilters(patchFilters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchFilterGroup.ReadOnly =
    zio.aws.ssm.model.PatchFilterGroup.wrap(buildAwsValue())
}
object PatchFilterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PatchFilterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchFilterGroup =
      zio.aws.ssm.model.PatchFilterGroup(patchFilters.map { item =>
        item.asEditable
      })
    def patchFilters: List[zio.aws.ssm.model.PatchFilter.ReadOnly]
    def getPatchFilters
        : ZIO[Any, Nothing, List[zio.aws.ssm.model.PatchFilter.ReadOnly]] =
      ZIO.succeed(patchFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchFilterGroup
  ) extends zio.aws.ssm.model.PatchFilterGroup.ReadOnly {
    override val patchFilters: List[zio.aws.ssm.model.PatchFilter.ReadOnly] =
      impl
        .patchFilters()
        .asScala
        .map { item =>
          zio.aws.ssm.model.PatchFilter.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchFilterGroup
  ): zio.aws.ssm.model.PatchFilterGroup.ReadOnly = new Wrapper(impl)
}
