package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DefaultBaseline,
  BaselineDescription,
  BaselineName,
  BaselineId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PatchBaselineIdentity(
    baselineId: Option[BaselineId] = None,
    baselineName: Option[BaselineName] = None,
    operatingSystem: Option[zio.aws.ssm.model.OperatingSystem] = None,
    baselineDescription: Option[BaselineDescription] = None,
    defaultBaseline: Option[DefaultBaseline] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity = {
    import PatchBaselineIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .optionallyWith(
        baselineName.map(value => BaselineName.unwrap(value): java.lang.String)
      )(_.baselineName)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(
        baselineDescription.map(value =>
          BaselineDescription.unwrap(value): java.lang.String
        )
      )(_.baselineDescription)
      .optionallyWith(
        defaultBaseline.map(value =>
          DefaultBaseline.unwrap(value): java.lang.Boolean
        )
      )(_.defaultBaseline)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly =
    zio.aws.ssm.model.PatchBaselineIdentity.wrap(buildAwsValue())
}
object PatchBaselineIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchBaselineIdentity =
      zio.aws.ssm.model.PatchBaselineIdentity(
        baselineId.map(value => value),
        baselineName.map(value => value),
        operatingSystem.map(value => value),
        baselineDescription.map(value => value),
        defaultBaseline.map(value => value)
      )
    def baselineId: Option[BaselineId]
    def baselineName: Option[BaselineName]
    def operatingSystem: Option[zio.aws.ssm.model.OperatingSystem]
    def baselineDescription: Option[BaselineDescription]
    def defaultBaseline: Option[DefaultBaseline]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
    def getBaselineName: ZIO[Any, AwsError, BaselineName] =
      AwsError.unwrapOptionField("baselineName", baselineName)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.ssm.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getBaselineDescription: ZIO[Any, AwsError, BaselineDescription] =
      AwsError.unwrapOptionField("baselineDescription", baselineDescription)
    def getDefaultBaseline: ZIO[Any, AwsError, DefaultBaseline] =
      AwsError.unwrapOptionField("defaultBaseline", defaultBaseline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity
  ) extends zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly {
    override val baselineId: Option[BaselineId] = scala
      .Option(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
    override val baselineName: Option[BaselineName] = scala
      .Option(impl.baselineName())
      .map(value => zio.aws.ssm.model.primitives.BaselineName(value))
    override val operatingSystem: Option[zio.aws.ssm.model.OperatingSystem] =
      scala
        .Option(impl.operatingSystem())
        .map(value => zio.aws.ssm.model.OperatingSystem.wrap(value))
    override val baselineDescription: Option[BaselineDescription] = scala
      .Option(impl.baselineDescription())
      .map(value => zio.aws.ssm.model.primitives.BaselineDescription(value))
    override val defaultBaseline: Option[DefaultBaseline] = scala
      .Option(impl.defaultBaseline())
      .map(value => zio.aws.ssm.model.primitives.DefaultBaseline(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity
  ): zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly = new Wrapper(impl)
}
