package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListResourceComplianceSummariesResponse(
    resourceComplianceSummaryItems: Option[
      Iterable[zio.aws.ssm.model.ResourceComplianceSummaryItem]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse = {
    import ListResourceComplianceSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse
      .builder()
      .optionallyWith(
        resourceComplianceSummaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceComplianceSummaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.ListResourceComplianceSummariesResponse.ReadOnly =
    zio.aws.ssm.model.ListResourceComplianceSummariesResponse
      .wrap(buildAwsValue())
}
object ListResourceComplianceSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListResourceComplianceSummariesResponse =
      zio.aws.ssm.model.ListResourceComplianceSummariesResponse(
        resourceComplianceSummaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceComplianceSummaryItems
        : Option[List[zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly]]
    def nextToken: Option[NextToken]
    def getResourceComplianceSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceComplianceSummaryItems",
      resourceComplianceSummaryItems
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse
  ) extends zio.aws.ssm.model.ListResourceComplianceSummariesResponse.ReadOnly {
    override val resourceComplianceSummaryItems: Option[
      List[zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly]
    ] = scala
      .Option(impl.resourceComplianceSummaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.ResourceComplianceSummaryItem.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse
  ): zio.aws.ssm.model.ListResourceComplianceSummariesResponse.ReadOnly =
    new Wrapper(impl)
}
