package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{OpsItemRelatedItemsMaxResults, OpsItemId}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListOpsItemRelatedItemsRequest(
    opsItemId: Option[OpsItemId] = None,
    filters: Option[Iterable[zio.aws.ssm.model.OpsItemRelatedItemsFilter]] =
      None,
    maxResults: Option[OpsItemRelatedItemsMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest = {
    import ListOpsItemRelatedItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest
      .builder()
      .optionallyWith(
        opsItemId.map(value => OpsItemId.unwrap(value): java.lang.String)
      )(_.opsItemId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          OpsItemRelatedItemsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest.ReadOnly =
    zio.aws.ssm.model.ListOpsItemRelatedItemsRequest.wrap(buildAwsValue())
}
object ListOpsItemRelatedItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest =
      zio.aws.ssm.model.ListOpsItemRelatedItemsRequest(
        opsItemId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def opsItemId: Option[OpsItemId]
    def filters
        : Option[List[zio.aws.ssm.model.OpsItemRelatedItemsFilter.ReadOnly]]
    def maxResults: Option[OpsItemRelatedItemsMaxResults]
    def nextToken: Option[String]
    def getOpsItemId: ZIO[Any, AwsError, OpsItemId] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemRelatedItemsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, OpsItemRelatedItemsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest
  ) extends zio.aws.ssm.model.ListOpsItemRelatedItemsRequest.ReadOnly {
    override val opsItemId: Option[OpsItemId] = scala
      .Option(impl.opsItemId())
      .map(value => zio.aws.ssm.model.primitives.OpsItemId(value))
    override val filters
        : Option[List[zio.aws.ssm.model.OpsItemRelatedItemsFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsItemRelatedItemsFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[OpsItemRelatedItemsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ssm.model.primitives.OpsItemRelatedItemsMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest
  ): zio.aws.ssm.model.ListOpsItemRelatedItemsRequest.ReadOnly = new Wrapper(
    impl
  )
}
