package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  InventoryItemTypeName,
  InstanceId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInventoryEntriesRequest(
    instanceId: InstanceId,
    typeName: InventoryItemTypeName,
    filters: Option[Iterable[zio.aws.ssm.model.InventoryFilter]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest = {
    import ListInventoryEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .typeName(InventoryItemTypeName.unwrap(typeName): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListInventoryEntriesRequest.ReadOnly =
    zio.aws.ssm.model.ListInventoryEntriesRequest.wrap(buildAwsValue())
}
object ListInventoryEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListInventoryEntriesRequest =
      zio.aws.ssm.model.ListInventoryEntriesRequest(
        instanceId,
        typeName,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def typeName: InventoryItemTypeName
    def filters: Option[List[zio.aws.ssm.model.InventoryFilter.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTypeName: ZIO[Any, Nothing, InventoryItemTypeName] =
      ZIO.succeed(typeName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.InventoryFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest
  ) extends zio.aws.ssm.model.ListInventoryEntriesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val typeName: InventoryItemTypeName =
      zio.aws.ssm.model.primitives.InventoryItemTypeName(impl.typeName())
    override val filters
        : Option[List[zio.aws.ssm.model.InventoryFilter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InventoryFilter.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest
  ): zio.aws.ssm.model.ListInventoryEntriesRequest.ReadOnly = new Wrapper(impl)
}
