package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ChangeRequestName,
  TargetMapValue,
  AutomationParameterValue,
  AutomationExecutionId,
  DocumentName,
  TargetMapKey,
  DocumentVersion,
  AutomationParameterKey,
  DateTime,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AutomationExecution(
    automationExecutionId: Option[AutomationExecutionId] = None,
    documentName: Option[DocumentName] = None,
    documentVersion: Option[DocumentVersion] = None,
    executionStartTime: Option[DateTime] = None,
    executionEndTime: Option[DateTime] = None,
    automationExecutionStatus: Option[
      zio.aws.ssm.model.AutomationExecutionStatus
    ] = None,
    stepExecutions: Option[Iterable[zio.aws.ssm.model.StepExecution]] = None,
    stepExecutionsTruncated: Option[Boolean] = None,
    parameters: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None,
    outputs: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None,
    failureMessage: Option[String] = None,
    mode: Option[zio.aws.ssm.model.ExecutionMode] = None,
    parentAutomationExecutionId: Option[AutomationExecutionId] = None,
    executedBy: Option[String] = None,
    currentStepName: Option[String] = None,
    currentAction: Option[String] = None,
    targetParameterName: Option[AutomationParameterKey] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    targetMaps: Option[Iterable[Map[TargetMapKey, Iterable[TargetMapValue]]]] =
      None,
    resolvedTargets: Option[zio.aws.ssm.model.ResolvedTargets] = None,
    maxConcurrency: Option[MaxConcurrency] = None,
    maxErrors: Option[MaxErrors] = None,
    target: Option[String] = None,
    targetLocations: Option[Iterable[zio.aws.ssm.model.TargetLocation]] = None,
    progressCounters: Option[zio.aws.ssm.model.ProgressCounters] = None,
    automationSubtype: Option[zio.aws.ssm.model.AutomationSubtype] = None,
    scheduledTime: Option[DateTime] = None,
    runbooks: Option[Iterable[zio.aws.ssm.model.Runbook]] = None,
    opsItemId: Option[String] = None,
    associationId: Option[String] = None,
    changeRequestName: Option[ChangeRequestName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AutomationExecution = {
    import AutomationExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AutomationExecution
      .builder()
      .optionallyWith(
        automationExecutionId.map(value =>
          AutomationExecutionId.unwrap(value): java.lang.String
        )
      )(_.automationExecutionId)
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        executionStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionStartTime)
      .optionallyWith(
        executionEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionEndTime)
      .optionallyWith(automationExecutionStatus.map(value => value.unwrap))(
        _.automationExecutionStatus
      )
      .optionallyWith(
        stepExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stepExecutions)
      .optionallyWith(
        stepExecutionsTruncated.map(value => value: java.lang.Boolean)
      )(_.stepExecutionsTruncated)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        outputs.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.outputs)
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        parentAutomationExecutionId.map(value =>
          AutomationExecutionId.unwrap(value): java.lang.String
        )
      )(_.parentAutomationExecutionId)
      .optionallyWith(executedBy.map(value => value: java.lang.String))(
        _.executedBy
      )
      .optionallyWith(currentStepName.map(value => value: java.lang.String))(
        _.currentStepName
      )
      .optionallyWith(currentAction.map(value => value: java.lang.String))(
        _.currentAction
      )
      .optionallyWith(
        targetParameterName.map(value =>
          AutomationParameterKey.unwrap(value): java.lang.String
        )
      )(_.targetParameterName)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        targetMaps.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TargetMapKey.unwrap(key): java.lang.String) -> value.map {
                  item =>
                    TargetMapValue.unwrap(item): java.lang.String
                }.asJavaCollection
              })
              .asJava
          }.asJavaCollection
        )
      )(_.targetMaps)
      .optionallyWith(resolvedTargets.map(value => value.buildAwsValue()))(
        _.resolvedTargets
      )
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(target.map(value => value: java.lang.String))(_.target)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .optionallyWith(progressCounters.map(value => value.buildAwsValue()))(
        _.progressCounters
      )
      .optionallyWith(automationSubtype.map(value => value.unwrap))(
        _.automationSubtype
      )
      .optionallyWith(
        scheduledTime.map(value => DateTime.unwrap(value): Instant)
      )(_.scheduledTime)
      .optionallyWith(
        runbooks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.runbooks)
      .optionallyWith(opsItemId.map(value => value: java.lang.String))(
        _.opsItemId
      )
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(
        changeRequestName.map(value =>
          ChangeRequestName.unwrap(value): java.lang.String
        )
      )(_.changeRequestName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AutomationExecution.ReadOnly =
    zio.aws.ssm.model.AutomationExecution.wrap(buildAwsValue())
}
object AutomationExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AutomationExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AutomationExecution =
      zio.aws.ssm.model.AutomationExecution(
        automationExecutionId.map(value => value),
        documentName.map(value => value),
        documentVersion.map(value => value),
        executionStartTime.map(value => value),
        executionEndTime.map(value => value),
        automationExecutionStatus.map(value => value),
        stepExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stepExecutionsTruncated.map(value => value),
        parameters.map(value => value),
        outputs.map(value => value),
        failureMessage.map(value => value),
        mode.map(value => value),
        parentAutomationExecutionId.map(value => value),
        executedBy.map(value => value),
        currentStepName.map(value => value),
        currentAction.map(value => value),
        targetParameterName.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetMaps.map(value => value),
        resolvedTargets.map(value => value.asEditable),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        target.map(value => value),
        targetLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        progressCounters.map(value => value.asEditable),
        automationSubtype.map(value => value),
        scheduledTime.map(value => value),
        runbooks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        opsItemId.map(value => value),
        associationId.map(value => value),
        changeRequestName.map(value => value)
      )
    def automationExecutionId: Option[AutomationExecutionId]
    def documentName: Option[DocumentName]
    def documentVersion: Option[DocumentVersion]
    def executionStartTime: Option[DateTime]
    def executionEndTime: Option[DateTime]
    def automationExecutionStatus
        : Option[zio.aws.ssm.model.AutomationExecutionStatus]
    def stepExecutions: Option[List[zio.aws.ssm.model.StepExecution.ReadOnly]]
    def stepExecutionsTruncated: Option[Boolean]
    def parameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def outputs
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def failureMessage: Option[String]
    def mode: Option[zio.aws.ssm.model.ExecutionMode]
    def parentAutomationExecutionId: Option[AutomationExecutionId]
    def executedBy: Option[String]
    def currentStepName: Option[String]
    def currentAction: Option[String]
    def targetParameterName: Option[AutomationParameterKey]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def targetMaps: Option[List[Map[TargetMapKey, List[TargetMapValue]]]]
    def resolvedTargets: Option[zio.aws.ssm.model.ResolvedTargets.ReadOnly]
    def maxConcurrency: Option[MaxConcurrency]
    def maxErrors: Option[MaxErrors]
    def target: Option[String]
    def targetLocations: Option[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def progressCounters: Option[zio.aws.ssm.model.ProgressCounters.ReadOnly]
    def automationSubtype: Option[zio.aws.ssm.model.AutomationSubtype]
    def scheduledTime: Option[DateTime]
    def runbooks: Option[List[zio.aws.ssm.model.Runbook.ReadOnly]]
    def opsItemId: Option[String]
    def associationId: Option[String]
    def changeRequestName: Option[ChangeRequestName]
    def getAutomationExecutionId: ZIO[Any, AwsError, AutomationExecutionId] =
      AwsError.unwrapOptionField("automationExecutionId", automationExecutionId)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getExecutionStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionStartTime", executionStartTime)
    def getExecutionEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionEndTime", executionEndTime)
    def getAutomationExecutionStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationExecutionStatus] =
      AwsError.unwrapOptionField(
        "automationExecutionStatus",
        automationExecutionStatus
      )
    def getStepExecutions
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.StepExecution.ReadOnly]] =
      AwsError.unwrapOptionField("stepExecutions", stepExecutions)
    def getStepExecutionsTruncated: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("stepExecutionsTruncated", stepExecutionsTruncated)
    def getParameters: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getOutputs: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("outputs", outputs)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getMode: ZIO[Any, AwsError, zio.aws.ssm.model.ExecutionMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getParentAutomationExecutionId
        : ZIO[Any, AwsError, AutomationExecutionId] =
      AwsError.unwrapOptionField(
        "parentAutomationExecutionId",
        parentAutomationExecutionId
      )
    def getExecutedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executedBy", executedBy)
    def getCurrentStepName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentStepName", currentStepName)
    def getCurrentAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentAction", currentAction)
    def getTargetParameterName: ZIO[Any, AwsError, AutomationParameterKey] =
      AwsError.unwrapOptionField("targetParameterName", targetParameterName)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTargetMaps
        : ZIO[Any, AwsError, List[Map[TargetMapKey, List[TargetMapValue]]]] =
      AwsError.unwrapOptionField("targetMaps", targetMaps)
    def getResolvedTargets
        : ZIO[Any, AwsError, zio.aws.ssm.model.ResolvedTargets.ReadOnly] =
      AwsError.unwrapOptionField("resolvedTargets", resolvedTargets)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("target", target)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
    def getProgressCounters
        : ZIO[Any, AwsError, zio.aws.ssm.model.ProgressCounters.ReadOnly] =
      AwsError.unwrapOptionField("progressCounters", progressCounters)
    def getAutomationSubtype
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationSubtype] =
      AwsError.unwrapOptionField("automationSubtype", automationSubtype)
    def getScheduledTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("scheduledTime", scheduledTime)
    def getRunbooks
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Runbook.ReadOnly]] =
      AwsError.unwrapOptionField("runbooks", runbooks)
    def getOpsItemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getChangeRequestName: ZIO[Any, AwsError, ChangeRequestName] =
      AwsError.unwrapOptionField("changeRequestName", changeRequestName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AutomationExecution
  ) extends zio.aws.ssm.model.AutomationExecution.ReadOnly {
    override val automationExecutionId: Option[AutomationExecutionId] = scala
      .Option(impl.automationExecutionId())
      .map(value => zio.aws.ssm.model.primitives.AutomationExecutionId(value))
    override val documentName: Option[DocumentName] = scala
      .Option(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val executionStartTime: Option[DateTime] = scala
      .Option(impl.executionStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val executionEndTime: Option[DateTime] = scala
      .Option(impl.executionEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val automationExecutionStatus
        : Option[zio.aws.ssm.model.AutomationExecutionStatus] = scala
      .Option(impl.automationExecutionStatus())
      .map(value => zio.aws.ssm.model.AutomationExecutionStatus.wrap(value))
    override val stepExecutions
        : Option[List[zio.aws.ssm.model.StepExecution.ReadOnly]] = scala
      .Option(impl.stepExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.StepExecution.wrap(item)
        }.toList
      )
    override val stepExecutionsTruncated: Option[Boolean] =
      scala.Option(impl.stepExecutionsTruncated()).map(value => value: Boolean)
    override val parameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val outputs
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.outputs())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val failureMessage: Option[String] =
      scala.Option(impl.failureMessage()).map(value => value: String)
    override val mode: Option[zio.aws.ssm.model.ExecutionMode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.ssm.model.ExecutionMode.wrap(value))
    override val parentAutomationExecutionId: Option[AutomationExecutionId] =
      scala
        .Option(impl.parentAutomationExecutionId())
        .map(value => zio.aws.ssm.model.primitives.AutomationExecutionId(value))
    override val executedBy: Option[String] =
      scala.Option(impl.executedBy()).map(value => value: String)
    override val currentStepName: Option[String] =
      scala.Option(impl.currentStepName()).map(value => value: String)
    override val currentAction: Option[String] =
      scala.Option(impl.currentAction()).map(value => value: String)
    override val targetParameterName: Option[AutomationParameterKey] = scala
      .Option(impl.targetParameterName())
      .map(value => zio.aws.ssm.model.primitives.AutomationParameterKey(value))
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val targetMaps
        : Option[List[Map[TargetMapKey, List[TargetMapValue]]]] = scala
      .Option(impl.targetMaps())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .TargetMapKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.TargetMapValue(item)
              }.toList
            })
            .toMap
        }.toList
      )
    override val resolvedTargets
        : Option[zio.aws.ssm.model.ResolvedTargets.ReadOnly] = scala
      .Option(impl.resolvedTargets())
      .map(value => zio.aws.ssm.model.ResolvedTargets.wrap(value))
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Option[MaxErrors] = scala
      .Option(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val target: Option[String] =
      scala.Option(impl.target()).map(value => value: String)
    override val targetLocations
        : Option[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] = scala
      .Option(impl.targetLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.TargetLocation.wrap(item)
        }.toList
      )
    override val progressCounters
        : Option[zio.aws.ssm.model.ProgressCounters.ReadOnly] = scala
      .Option(impl.progressCounters())
      .map(value => zio.aws.ssm.model.ProgressCounters.wrap(value))
    override val automationSubtype
        : Option[zio.aws.ssm.model.AutomationSubtype] = scala
      .Option(impl.automationSubtype())
      .map(value => zio.aws.ssm.model.AutomationSubtype.wrap(value))
    override val scheduledTime: Option[DateTime] = scala
      .Option(impl.scheduledTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val runbooks: Option[List[zio.aws.ssm.model.Runbook.ReadOnly]] =
      scala
        .Option(impl.runbooks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Runbook.wrap(item)
          }.toList
        )
    override val opsItemId: Option[String] =
      scala.Option(impl.opsItemId()).map(value => value: String)
    override val associationId: Option[String] =
      scala.Option(impl.associationId()).map(value => value: String)
    override val changeRequestName: Option[ChangeRequestName] = scala
      .Option(impl.changeRequestName())
      .map(value => zio.aws.ssm.model.primitives.ChangeRequestName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AutomationExecution
  ): zio.aws.ssm.model.AutomationExecution.ReadOnly = new Wrapper(impl)
}
