package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EmailTemplateData,
  AmazonResourceName,
  EmailTemplateName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Template(
    templateName: Optional[EmailTemplateName] = Optional.Absent,
    templateArn: Optional[AmazonResourceName] = Optional.Absent,
    templateData: Optional[EmailTemplateData] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sesv2.model.Template = {
    import Template.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.Template
      .builder()
      .optionallyWith(
        templateName.map(value =>
          EmailTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        templateArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.templateArn)
      .optionallyWith(
        templateData.map(value =>
          EmailTemplateData.unwrap(value): java.lang.String
        )
      )(_.templateData)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.Template.ReadOnly =
    zio.aws.sesv2.model.Template.wrap(buildAwsValue())
}
object Template {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.Template] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.Template = zio.aws.sesv2.model.Template(
      templateName.map(value => value),
      templateArn.map(value => value),
      templateData.map(value => value)
    )
    def templateName: Optional[EmailTemplateName]
    def templateArn: Optional[AmazonResourceName]
    def templateData: Optional[EmailTemplateData]
    def getTemplateName: ZIO[Any, AwsError, EmailTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getTemplateArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateData: ZIO[Any, AwsError, EmailTemplateData] =
      AwsError.unwrapOptionField("templateData", templateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.Template
  ) extends zio.aws.sesv2.model.Template.ReadOnly {
    override val templateName: Optional[EmailTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value => zio.aws.sesv2.model.primitives.EmailTemplateName(value))
    override val templateArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateArn())
        .map(value => zio.aws.sesv2.model.primitives.AmazonResourceName(value))
    override val templateData: Optional[EmailTemplateData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateData())
        .map(value => zio.aws.sesv2.model.primitives.EmailTemplateData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.Template
  ): zio.aws.sesv2.model.Template.ReadOnly = new Wrapper(impl)
}
