package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Timestamp, EmailAddress}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SuppressedDestinationSummary(
    emailAddress: EmailAddress,
    reason: zio.aws.sesv2.model.SuppressionListReason,
    lastUpdateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SuppressedDestinationSummary = {
    import SuppressedDestinationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SuppressedDestinationSummary
      .builder()
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .reason(reason.unwrap)
      .lastUpdateTime(Timestamp.unwrap(lastUpdateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly =
    zio.aws.sesv2.model.SuppressedDestinationSummary.wrap(buildAwsValue())
}
object SuppressedDestinationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SuppressedDestinationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SuppressedDestinationSummary =
      zio.aws.sesv2.model
        .SuppressedDestinationSummary(emailAddress, reason, lastUpdateTime)
    def emailAddress: EmailAddress
    def reason: zio.aws.sesv2.model.SuppressionListReason
    def lastUpdateTime: Timestamp
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
    def getReason
        : ZIO[Any, Nothing, zio.aws.sesv2.model.SuppressionListReason] =
      ZIO.succeed(reason)
    def getLastUpdateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SuppressedDestinationSummary
  ) extends zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly {
    override val emailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.emailAddress())
    override val reason: zio.aws.sesv2.model.SuppressionListReason =
      zio.aws.sesv2.model.SuppressionListReason.wrap(impl.reason())
    override val lastUpdateTime: Timestamp =
      zio.aws.sesv2.model.primitives.Timestamp(impl.lastUpdateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SuppressedDestinationSummary
  ): zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly = new Wrapper(
    impl
  )
}
