package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListContactListsResponse(
    contactLists: Optional[Iterable[zio.aws.sesv2.model.ContactList]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListContactListsResponse = {
    import ListContactListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListContactListsResponse
      .builder()
      .optionallyWith(
        contactLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contactLists)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListContactListsResponse.ReadOnly =
    zio.aws.sesv2.model.ListContactListsResponse.wrap(buildAwsValue())
}
object ListContactListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListContactListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListContactListsResponse =
      zio.aws.sesv2.model.ListContactListsResponse(
        contactLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def contactLists: Optional[List[zio.aws.sesv2.model.ContactList.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getContactLists
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.ContactList.ReadOnly]] =
      AwsError.unwrapOptionField("contactLists", contactLists)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactListsResponse
  ) extends zio.aws.sesv2.model.ListContactListsResponse.ReadOnly {
    override val contactLists
        : Optional[List[zio.aws.sesv2.model.ContactList.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactLists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.ContactList.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactListsResponse
  ): zio.aws.sesv2.model.ListContactListsResponse.ReadOnly = new Wrapper(impl)
}
