package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{EmailAddress, ContactListName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetContactRequest(
    contactListName: ContactListName,
    emailAddress: EmailAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetContactRequest = {
    import GetContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetContactRequest
      .builder()
      .contactListName(
        ContactListName.unwrap(contactListName): java.lang.String
      )
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetContactRequest.ReadOnly =
    zio.aws.sesv2.model.GetContactRequest.wrap(buildAwsValue())
}
object GetContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetContactRequest =
      zio.aws.sesv2.model.GetContactRequest(contactListName, emailAddress)
    def contactListName: ContactListName
    def emailAddress: EmailAddress
    def getContactListName: ZIO[Any, Nothing, ContactListName] =
      ZIO.succeed(contactListName)
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetContactRequest
  ) extends zio.aws.sesv2.model.GetContactRequest.ReadOnly {
    override val contactListName: ContactListName =
      zio.aws.sesv2.model.primitives.ContactListName(impl.contactListName())
    override val emailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.emailAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetContactRequest
  ): zio.aws.sesv2.model.GetContactRequest.ReadOnly = new Wrapper(impl)
}
