package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ContactListName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteContactListRequest(contactListName: ContactListName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest = {
    import DeleteContactListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest
      .builder()
      .contactListName(
        ContactListName.unwrap(contactListName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DeleteContactListRequest.ReadOnly =
    zio.aws.sesv2.model.DeleteContactListRequest.wrap(buildAwsValue())
}
object DeleteContactListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DeleteContactListRequest =
      zio.aws.sesv2.model.DeleteContactListRequest(contactListName)
    def contactListName: ContactListName
    def getContactListName: ZIO[Any, Nothing, ContactListName] =
      ZIO.succeed(contactListName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest
  ) extends zio.aws.sesv2.model.DeleteContactListRequest.ReadOnly {
    override val contactListName: ContactListName =
      zio.aws.sesv2.model.primitives.ContactListName(impl.contactListName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteContactListRequest
  ): zio.aws.sesv2.model.DeleteContactListRequest.ReadOnly = new Wrapper(impl)
}
