package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetMetricDataRequest(
    queries: Iterable[zio.aws.sesv2.model.BatchGetMetricDataQuery]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest = {
    import BatchGetMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest
      .builder()
      .queries(queries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.BatchGetMetricDataRequest.ReadOnly =
    zio.aws.sesv2.model.BatchGetMetricDataRequest.wrap(buildAwsValue())
}
object BatchGetMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.BatchGetMetricDataRequest =
      zio.aws.sesv2.model.BatchGetMetricDataRequest(queries.map { item =>
        item.asEditable
      })
    def queries: List[zio.aws.sesv2.model.BatchGetMetricDataQuery.ReadOnly]
    def getQueries: ZIO[Any, Nothing, List[
      zio.aws.sesv2.model.BatchGetMetricDataQuery.ReadOnly
    ]] = ZIO.succeed(queries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest
  ) extends zio.aws.sesv2.model.BatchGetMetricDataRequest.ReadOnly {
    override val queries
        : List[zio.aws.sesv2.model.BatchGetMetricDataQuery.ReadOnly] = impl
      .queries()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.BatchGetMetricDataQuery.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataRequest
  ): zio.aws.sesv2.model.BatchGetMetricDataRequest.ReadOnly = new Wrapper(impl)
}
