package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{EmailTemplateData, EmailTemplateName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestRenderEmailTemplateRequest(
    templateName: EmailTemplateName,
    templateData: EmailTemplateData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest = {
    import TestRenderEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest
      .builder()
      .templateName(EmailTemplateName.unwrap(templateName): java.lang.String)
      .templateData(EmailTemplateData.unwrap(templateData): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.TestRenderEmailTemplateRequest.ReadOnly =
    zio.aws.sesv2.model.TestRenderEmailTemplateRequest.wrap(buildAwsValue())
}
object TestRenderEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.TestRenderEmailTemplateRequest =
      zio.aws.sesv2.model
        .TestRenderEmailTemplateRequest(templateName, templateData)
    def templateName: EmailTemplateName
    def templateData: EmailTemplateData
    def getTemplateName: ZIO[Any, Nothing, EmailTemplateName] =
      ZIO.succeed(templateName)
    def getTemplateData: ZIO[Any, Nothing, EmailTemplateData] =
      ZIO.succeed(templateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest
  ) extends zio.aws.sesv2.model.TestRenderEmailTemplateRequest.ReadOnly {
    override val templateName: EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName(impl.templateName())
    override val templateData: EmailTemplateData =
      zio.aws.sesv2.model.primitives.EmailTemplateData(impl.templateData())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateRequest
  ): zio.aws.sesv2.model.TestRenderEmailTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
