package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PinpointDestination(
    applicationArn: Optional[AmazonResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PinpointDestination = {
    import PinpointDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PinpointDestination
      .builder()
      .optionallyWith(
        applicationArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.applicationArn)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.PinpointDestination.ReadOnly =
    zio.aws.sesv2.model.PinpointDestination.wrap(buildAwsValue())
}
object PinpointDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PinpointDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.PinpointDestination =
      zio.aws.sesv2.model
        .PinpointDestination(applicationArn.map(value => value))
    def applicationArn: Optional[AmazonResourceName]
    def getApplicationArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("applicationArn", applicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PinpointDestination
  ) extends zio.aws.sesv2.model.PinpointDestination.ReadOnly {
    override val applicationArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationArn())
        .map(value => zio.aws.sesv2.model.primitives.AmazonResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PinpointDestination
  ): zio.aws.sesv2.model.PinpointDestination.ReadOnly = new Wrapper(impl)
}
