package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{TagKey, AmazonResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: AmazonResourceName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.UntagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.UntagResourceRequest.ReadOnly =
    zio.aws.sesv2.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.UntagResourceRequest =
      zio.aws.sesv2.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: AmazonResourceName
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.UntagResourceRequest
  ) extends zio.aws.sesv2.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.sesv2.model.primitives.AmazonResourceName(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.UntagResourceRequest
  ): zio.aws.sesv2.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
