package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  UseDefaultIfPreferenceUnavailable,
  TopicName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TopicFilter(
    topicName: Optional[TopicName] = Optional.Absent,
    useDefaultIfPreferenceUnavailable: Optional[
      UseDefaultIfPreferenceUnavailable
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.TopicFilter = {
    import TopicFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.TopicFilter
      .builder()
      .optionallyWith(
        topicName.map(value => TopicName.unwrap(value): java.lang.String)
      )(_.topicName)
      .optionallyWith(
        useDefaultIfPreferenceUnavailable.map(value =>
          UseDefaultIfPreferenceUnavailable.unwrap(value): java.lang.Boolean
        )
      )(_.useDefaultIfPreferenceUnavailable)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.TopicFilter.ReadOnly =
    zio.aws.sesv2.model.TopicFilter.wrap(buildAwsValue())
}
object TopicFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.TopicFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.TopicFilter =
      zio.aws.sesv2.model.TopicFilter(
        topicName.map(value => value),
        useDefaultIfPreferenceUnavailable.map(value => value)
      )
    def topicName: Optional[TopicName]
    def useDefaultIfPreferenceUnavailable
        : Optional[UseDefaultIfPreferenceUnavailable]
    def getTopicName: ZIO[Any, AwsError, TopicName] =
      AwsError.unwrapOptionField("topicName", topicName)
    def getUseDefaultIfPreferenceUnavailable
        : ZIO[Any, AwsError, UseDefaultIfPreferenceUnavailable] =
      AwsError.unwrapOptionField(
        "useDefaultIfPreferenceUnavailable",
        useDefaultIfPreferenceUnavailable
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.TopicFilter
  ) extends zio.aws.sesv2.model.TopicFilter.ReadOnly {
    override val topicName: Optional[TopicName] = zio.aws.core.internal
      .optionalFromNullable(impl.topicName())
      .map(value => zio.aws.sesv2.model.primitives.TopicName(value))
    override val useDefaultIfPreferenceUnavailable
        : Optional[UseDefaultIfPreferenceUnavailable] = zio.aws.core.internal
      .optionalFromNullable(impl.useDefaultIfPreferenceUnavailable())
      .map(value =>
        zio.aws.sesv2.model.primitives.UseDefaultIfPreferenceUnavailable(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.TopicFilter
  ): zio.aws.sesv2.model.TopicFilter.ReadOnly = new Wrapper(impl)
}
