package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{FeedbackId, OutboundMessageId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SuppressedDestinationAttributes(
    messageId: Optional[OutboundMessageId] = Optional.Absent,
    feedbackId: Optional[FeedbackId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SuppressedDestinationAttributes = {
    import SuppressedDestinationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SuppressedDestinationAttributes
      .builder()
      .optionallyWith(
        messageId.map(value =>
          OutboundMessageId.unwrap(value): java.lang.String
        )
      )(_.messageId)
      .optionallyWith(
        feedbackId.map(value => FeedbackId.unwrap(value): java.lang.String)
      )(_.feedbackId)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SuppressedDestinationAttributes.ReadOnly =
    zio.aws.sesv2.model.SuppressedDestinationAttributes.wrap(buildAwsValue())
}
object SuppressedDestinationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SuppressedDestinationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SuppressedDestinationAttributes =
      zio.aws.sesv2.model.SuppressedDestinationAttributes(
        messageId.map(value => value),
        feedbackId.map(value => value)
      )
    def messageId: Optional[OutboundMessageId]
    def feedbackId: Optional[FeedbackId]
    def getMessageId: ZIO[Any, AwsError, OutboundMessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getFeedbackId: ZIO[Any, AwsError, FeedbackId] =
      AwsError.unwrapOptionField("feedbackId", feedbackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SuppressedDestinationAttributes
  ) extends zio.aws.sesv2.model.SuppressedDestinationAttributes.ReadOnly {
    override val messageId: Optional[OutboundMessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.sesv2.model.primitives.OutboundMessageId(value))
    override val feedbackId: Optional[FeedbackId] = zio.aws.core.internal
      .optionalFromNullable(impl.feedbackId())
      .map(value => zio.aws.sesv2.model.primitives.FeedbackId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SuppressedDestinationAttributes
  ): zio.aws.sesv2.model.SuppressedDestinationAttributes.ReadOnly = new Wrapper(
    impl
  )
}
