package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SnsDestination(topicArn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SnsDestination = {
    import SnsDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SnsDestination
      .builder()
      .topicArn(AmazonResourceName.unwrap(topicArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SnsDestination.ReadOnly =
    zio.aws.sesv2.model.SnsDestination.wrap(buildAwsValue())
}
object SnsDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SnsDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SnsDestination =
      zio.aws.sesv2.model.SnsDestination(topicArn)
    def topicArn: AmazonResourceName
    def getTopicArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SnsDestination
  ) extends zio.aws.sesv2.model.SnsDestination.ReadOnly {
    override val topicArn: AmazonResourceName =
      zio.aws.sesv2.model.primitives.AmazonResourceName(impl.topicArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SnsDestination
  ): zio.aws.sesv2.model.SnsDestination.ReadOnly = new Wrapper(impl)
}
