package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{ConfigurationSetName, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutEmailIdentityConfigurationSetAttributesRequest(
    emailIdentity: Identity,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest = {
    import PutEmailIdentityConfigurationSetAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest.ReadOnly =
    zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest
      .wrap(buildAwsValue())
}
object PutEmailIdentityConfigurationSetAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest =
      zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest(
        emailIdentity,
        configurationSetName.map(value => value)
      )
    def emailIdentity: Identity
    def configurationSetName: Optional[ConfigurationSetName]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest
  ) extends zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.sesv2.model.primitives.ConfigurationSetName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest
  ): zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
