package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait MailType {
  def unwrap: software.amazon.awssdk.services.sesv2.model.MailType
}
object MailType {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.MailType
  ): zio.aws.sesv2.model.MailType = value match {
    case software.amazon.awssdk.services.sesv2.model.MailType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.MailType.MARKETING =>
      val r = MARKETING
      r
    case software.amazon.awssdk.services.sesv2.model.MailType.TRANSACTIONAL =>
      val r = TRANSACTIONAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.MailType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.MailType =
      software.amazon.awssdk.services.sesv2.model.MailType.UNKNOWN_TO_SDK_VERSION
  }
  case object MARKETING extends zio.aws.sesv2.model.MailType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.MailType =
      software.amazon.awssdk.services.sesv2.model.MailType.MARKETING
  }
  case object TRANSACTIONAL extends zio.aws.sesv2.model.MailType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.MailType =
      software.amazon.awssdk.services.sesv2.model.MailType.TRANSACTIONAL
  }
}
