package zio.aws.sesv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{
  MaxItems,
  NextToken,
  ListRecommendationFilterValue
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRecommendationsRequest(
    filter: Optional[Map[
      zio.aws.sesv2.model.ListRecommendationsFilterKey,
      ListRecommendationFilterValue
    ]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    pageSize: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest = {
    import ListRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (ListRecommendationFilterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.filterWithStrings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListRecommendationsRequest.ReadOnly =
    zio.aws.sesv2.model.ListRecommendationsRequest.wrap(buildAwsValue())
}
object ListRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListRecommendationsRequest =
      zio.aws.sesv2.model.ListRecommendationsRequest(
        filter.map(value => value),
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def filter: Optional[Map[
      zio.aws.sesv2.model.ListRecommendationsFilterKey,
      ListRecommendationFilterValue
    ]]
    def nextToken: Optional[NextToken]
    def pageSize: Optional[MaxItems]
    def getFilter: ZIO[Any, AwsError, Map[
      zio.aws.sesv2.model.ListRecommendationsFilterKey,
      ListRecommendationFilterValue
    ]] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest
  ) extends zio.aws.sesv2.model.ListRecommendationsRequest.ReadOnly {
    override val filter: Optional[Map[
      zio.aws.sesv2.model.ListRecommendationsFilterKey,
      ListRecommendationFilterValue
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sesv2.model.ListRecommendationsFilterKey
              .wrap(key) -> zio.aws.sesv2.model.primitives
              .ListRecommendationFilterValue(value)
          })
          .toMap
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
    override val pageSize: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListRecommendationsRequest
  ): zio.aws.sesv2.model.ListRecommendationsRequest.ReadOnly = new Wrapper(impl)
}
