package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait IdentityType {
  def unwrap: software.amazon.awssdk.services.sesv2.model.IdentityType
}
object IdentityType {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.IdentityType
  ): zio.aws.sesv2.model.IdentityType = value match {
    case software.amazon.awssdk.services.sesv2.model.IdentityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.IdentityType.EMAIL_ADDRESS =>
      val r = EMAIL_ADDRESS
      r
    case software.amazon.awssdk.services.sesv2.model.IdentityType.DOMAIN =>
      val r = DOMAIN
      r
    case software.amazon.awssdk.services.sesv2.model.IdentityType.MANAGED_DOMAIN =>
      val r = MANAGED_DOMAIN
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.IdentityType =
      software.amazon.awssdk.services.sesv2.model.IdentityType.UNKNOWN_TO_SDK_VERSION
  }
  case object EMAIL_ADDRESS extends zio.aws.sesv2.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.IdentityType =
      software.amazon.awssdk.services.sesv2.model.IdentityType.EMAIL_ADDRESS
  }
  case object DOMAIN extends zio.aws.sesv2.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.IdentityType =
      software.amazon.awssdk.services.sesv2.model.IdentityType.DOMAIN
  }
  case object MANAGED_DOMAIN extends zio.aws.sesv2.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.IdentityType =
      software.amazon.awssdk.services.sesv2.model.IdentityType.MANAGED_DOMAIN
  }
}
