package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Enabled, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IdentityInfo(
    identityType: Optional[zio.aws.sesv2.model.IdentityType] = Optional.Absent,
    identityName: Optional[Identity] = Optional.Absent,
    sendingEnabled: Optional[Enabled] = Optional.Absent,
    verificationStatus: Optional[zio.aws.sesv2.model.VerificationStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.IdentityInfo = {
    import IdentityInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.IdentityInfo
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        identityName.map(value => Identity.unwrap(value): java.lang.String)
      )(_.identityName)
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .optionallyWith(verificationStatus.map(value => value.unwrap))(
        _.verificationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.IdentityInfo.ReadOnly =
    zio.aws.sesv2.model.IdentityInfo.wrap(buildAwsValue())
}
object IdentityInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.IdentityInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.IdentityInfo =
      zio.aws.sesv2.model.IdentityInfo(
        identityType.map(value => value),
        identityName.map(value => value),
        sendingEnabled.map(value => value),
        verificationStatus.map(value => value)
      )
    def identityType: Optional[zio.aws.sesv2.model.IdentityType]
    def identityName: Optional[Identity]
    def sendingEnabled: Optional[Enabled]
    def verificationStatus: Optional[zio.aws.sesv2.model.VerificationStatus]
    def getIdentityType: ZIO[Any, AwsError, zio.aws.sesv2.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getIdentityName: ZIO[Any, AwsError, Identity] =
      AwsError.unwrapOptionField("identityName", identityName)
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
    def getVerificationStatus
        : ZIO[Any, AwsError, zio.aws.sesv2.model.VerificationStatus] =
      AwsError.unwrapOptionField("verificationStatus", verificationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.IdentityInfo
  ) extends zio.aws.sesv2.model.IdentityInfo.ReadOnly {
    override val identityType: Optional[zio.aws.sesv2.model.IdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityType())
        .map(value => zio.aws.sesv2.model.IdentityType.wrap(value))
    override val identityName: Optional[Identity] = zio.aws.core.internal
      .optionalFromNullable(impl.identityName())
      .map(value => zio.aws.sesv2.model.primitives.Identity(value))
    override val sendingEnabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val verificationStatus
        : Optional[zio.aws.sesv2.model.VerificationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verificationStatus())
        .map(value => zio.aws.sesv2.model.VerificationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.IdentityInfo
  ): zio.aws.sesv2.model.IdentityInfo.ReadOnly = new Wrapper(impl)
}
