package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailTemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEmailTemplateResponse(
    templateName: EmailTemplateName,
    templateContent: zio.aws.sesv2.model.EmailTemplateContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetEmailTemplateResponse = {
    import GetEmailTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetEmailTemplateResponse
      .builder()
      .templateName(EmailTemplateName.unwrap(templateName): java.lang.String)
      .templateContent(templateContent.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetEmailTemplateResponse.ReadOnly =
    zio.aws.sesv2.model.GetEmailTemplateResponse.wrap(buildAwsValue())
}
object GetEmailTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetEmailTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetEmailTemplateResponse =
      zio.aws.sesv2.model
        .GetEmailTemplateResponse(templateName, templateContent.asEditable)
    def templateName: EmailTemplateName
    def templateContent: zio.aws.sesv2.model.EmailTemplateContent.ReadOnly
    def getTemplateName: ZIO[Any, Nothing, EmailTemplateName] =
      ZIO.succeed(templateName)
    def getTemplateContent
        : ZIO[Any, Nothing, zio.aws.sesv2.model.EmailTemplateContent.ReadOnly] =
      ZIO.succeed(templateContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailTemplateResponse
  ) extends zio.aws.sesv2.model.GetEmailTemplateResponse.ReadOnly {
    override val templateName: EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName(impl.templateName())
    override val templateContent
        : zio.aws.sesv2.model.EmailTemplateContent.ReadOnly =
      zio.aws.sesv2.model.EmailTemplateContent.wrap(impl.templateContent())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailTemplateResponse
  ): zio.aws.sesv2.model.GetEmailTemplateResponse.ReadOnly = new Wrapper(impl)
}
