package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.PoolName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDedicatedIpPoolRequest(poolName: PoolName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest = {
    import GetDedicatedIpPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest
      .builder()
      .poolName(PoolName.unwrap(poolName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetDedicatedIpPoolRequest.ReadOnly =
    zio.aws.sesv2.model.GetDedicatedIpPoolRequest.wrap(buildAwsValue())
}
object GetDedicatedIpPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDedicatedIpPoolRequest =
      zio.aws.sesv2.model.GetDedicatedIpPoolRequest(poolName)
    def poolName: PoolName
    def getPoolName: ZIO[Any, Nothing, PoolName] = ZIO.succeed(poolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest
  ) extends zio.aws.sesv2.model.GetDedicatedIpPoolRequest.ReadOnly {
    override val poolName: PoolName =
      zio.aws.sesv2.model.primitives.PoolName(impl.poolName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolRequest
  ): zio.aws.sesv2.model.GetDedicatedIpPoolRequest.ReadOnly = new Wrapper(impl)
}
