package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ReportId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDeliverabilityTestReportResponse(
    reportId: ReportId,
    deliverabilityTestStatus: zio.aws.sesv2.model.DeliverabilityTestStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse = {
    import CreateDeliverabilityTestReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse
      .builder()
      .reportId(ReportId.unwrap(reportId): java.lang.String)
      .deliverabilityTestStatus(deliverabilityTestStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse.ReadOnly =
    zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse
      .wrap(buildAwsValue())
}
object CreateDeliverabilityTestReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse =
      zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse(
        reportId,
        deliverabilityTestStatus
      )
    def reportId: ReportId
    def deliverabilityTestStatus: zio.aws.sesv2.model.DeliverabilityTestStatus
    def getReportId: ZIO[Any, Nothing, ReportId] = ZIO.succeed(reportId)
    def getDeliverabilityTestStatus
        : ZIO[Any, Nothing, zio.aws.sesv2.model.DeliverabilityTestStatus] =
      ZIO.succeed(deliverabilityTestStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse
  ) extends zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse.ReadOnly {
    override val reportId: ReportId =
      zio.aws.sesv2.model.primitives.ReportId(impl.reportId())
    override val deliverabilityTestStatus
        : zio.aws.sesv2.model.DeliverabilityTestStatus =
      zio.aws.sesv2.model.DeliverabilityTestStatus
        .wrap(impl.deliverabilityTestStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse
  ): zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse.ReadOnly =
    new Wrapper(impl)
}
