package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.PoolName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDedicatedIpPoolRequest(
    poolName: PoolName,
    tags: Optional[Iterable[zio.aws.sesv2.model.Tag]] = Optional.Absent,
    scalingMode: Optional[zio.aws.sesv2.model.ScalingMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest = {
    import CreateDedicatedIpPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest
      .builder()
      .poolName(PoolName.unwrap(poolName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(scalingMode.map(value => value.unwrap))(_.scalingMode)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CreateDedicatedIpPoolRequest.ReadOnly =
    zio.aws.sesv2.model.CreateDedicatedIpPoolRequest.wrap(buildAwsValue())
}
object CreateDedicatedIpPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateDedicatedIpPoolRequest =
      zio.aws.sesv2.model.CreateDedicatedIpPoolRequest(
        poolName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scalingMode.map(value => value)
      )
    def poolName: PoolName
    def tags: Optional[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def scalingMode: Optional[zio.aws.sesv2.model.ScalingMode]
    def getPoolName: ZIO[Any, Nothing, PoolName] = ZIO.succeed(poolName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getScalingMode: ZIO[Any, AwsError, zio.aws.sesv2.model.ScalingMode] =
      AwsError.unwrapOptionField("scalingMode", scalingMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest
  ) extends zio.aws.sesv2.model.CreateDedicatedIpPoolRequest.ReadOnly {
    override val poolName: PoolName =
      zio.aws.sesv2.model.primitives.PoolName(impl.poolName())
    override val tags: Optional[List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.Tag.wrap(item)
          }.toList
        )
    override val scalingMode: Optional[zio.aws.sesv2.model.ScalingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingMode())
        .map(value => zio.aws.sesv2.model.ScalingMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest
  ): zio.aws.sesv2.model.CreateDedicatedIpPoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
