package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait VerificationStatus {
  def unwrap: software.amazon.awssdk.services.sesv2.model.VerificationStatus
}
object VerificationStatus {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.VerificationStatus
  ): zio.aws.sesv2.model.VerificationStatus = value match {
    case software.amazon.awssdk.services.sesv2.model.VerificationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.VerificationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.sesv2.model.VerificationStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.sesv2.model.VerificationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sesv2.model.VerificationStatus.TEMPORARY_FAILURE =>
      val r = TEMPORARY_FAILURE
      r
    case software.amazon.awssdk.services.sesv2.model.VerificationStatus.NOT_STARTED =>
      val r = NOT_STARTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.VerificationStatus =
      software.amazon.awssdk.services.sesv2.model.VerificationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.sesv2.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.VerificationStatus =
      software.amazon.awssdk.services.sesv2.model.VerificationStatus.PENDING
  }
  case object SUCCESS extends zio.aws.sesv2.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.VerificationStatus =
      software.amazon.awssdk.services.sesv2.model.VerificationStatus.SUCCESS
  }
  case object FAILED extends zio.aws.sesv2.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.VerificationStatus =
      software.amazon.awssdk.services.sesv2.model.VerificationStatus.FAILED
  }
  case object TEMPORARY_FAILURE extends zio.aws.sesv2.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.VerificationStatus =
      software.amazon.awssdk.services.sesv2.model.VerificationStatus.TEMPORARY_FAILURE
  }
  case object NOT_STARTED extends zio.aws.sesv2.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.VerificationStatus =
      software.amazon.awssdk.services.sesv2.model.VerificationStatus.NOT_STARTED
  }
}
