package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait TlsPolicy {
  def unwrap: software.amazon.awssdk.services.sesv2.model.TlsPolicy
}
object TlsPolicy {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.TlsPolicy
  ): zio.aws.sesv2.model.TlsPolicy = value match {
    case software.amazon.awssdk.services.sesv2.model.TlsPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.TlsPolicy.REQUIRE =>
      val r = REQUIRE
      r
    case software.amazon.awssdk.services.sesv2.model.TlsPolicy.OPTIONAL =>
      val r = OPTIONAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.TlsPolicy {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.TlsPolicy =
      software.amazon.awssdk.services.sesv2.model.TlsPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object REQUIRE extends zio.aws.sesv2.model.TlsPolicy {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.TlsPolicy =
      software.amazon.awssdk.services.sesv2.model.TlsPolicy.REQUIRE
  }
  case object OPTIONAL extends zio.aws.sesv2.model.TlsPolicy {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.TlsPolicy =
      software.amazon.awssdk.services.sesv2.model.TlsPolicy.OPTIONAL
  }
}
