package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSuppressedDestinationsResponse(
    suppressedDestinationSummaries: Optional[
      Iterable[zio.aws.sesv2.model.SuppressedDestinationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse = {
    import ListSuppressedDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse
      .builder()
      .optionallyWith(
        suppressedDestinationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suppressedDestinationSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly =
    zio.aws.sesv2.model.ListSuppressedDestinationsResponse.wrap(buildAwsValue())
}
object ListSuppressedDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListSuppressedDestinationsResponse =
      zio.aws.sesv2.model.ListSuppressedDestinationsResponse(
        suppressedDestinationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def suppressedDestinationSummaries: Optional[
      List[zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSuppressedDestinationSummaries: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "suppressedDestinationSummaries",
      suppressedDestinationSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse
  ) extends zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly {
    override val suppressedDestinationSummaries: Optional[
      List[zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.suppressedDestinationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.SuppressedDestinationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse
  ): zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly =
    new Wrapper(impl)
}
