package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GuardianOptions(
    optimizedSharedDelivery: Optional[zio.aws.sesv2.model.FeatureStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GuardianOptions = {
    import GuardianOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GuardianOptions
      .builder()
      .optionallyWith(optimizedSharedDelivery.map(value => value.unwrap))(
        _.optimizedSharedDelivery
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GuardianOptions.ReadOnly =
    zio.aws.sesv2.model.GuardianOptions.wrap(buildAwsValue())
}
object GuardianOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GuardianOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GuardianOptions = zio.aws.sesv2.model
      .GuardianOptions(optimizedSharedDelivery.map(value => value))
    def optimizedSharedDelivery: Optional[zio.aws.sesv2.model.FeatureStatus]
    def getOptimizedSharedDelivery
        : ZIO[Any, AwsError, zio.aws.sesv2.model.FeatureStatus] = AwsError
      .unwrapOptionField("optimizedSharedDelivery", optimizedSharedDelivery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GuardianOptions
  ) extends zio.aws.sesv2.model.GuardianOptions.ReadOnly {
    override val optimizedSharedDelivery
        : Optional[zio.aws.sesv2.model.FeatureStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.optimizedSharedDelivery())
      .map(value => zio.aws.sesv2.model.FeatureStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GuardianOptions
  ): zio.aws.sesv2.model.GuardianOptions.ReadOnly = new Wrapper(impl)
}
