package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VdmAttributes(
    vdmEnabled: zio.aws.sesv2.model.FeatureStatus,
    dashboardAttributes: Optional[zio.aws.sesv2.model.DashboardAttributes] =
      Optional.Absent,
    guardianAttributes: Optional[zio.aws.sesv2.model.GuardianAttributes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.VdmAttributes = {
    import VdmAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.VdmAttributes
      .builder()
      .vdmEnabled(vdmEnabled.unwrap)
      .optionallyWith(dashboardAttributes.map(value => value.buildAwsValue()))(
        _.dashboardAttributes
      )
      .optionallyWith(guardianAttributes.map(value => value.buildAwsValue()))(
        _.guardianAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.VdmAttributes.ReadOnly =
    zio.aws.sesv2.model.VdmAttributes.wrap(buildAwsValue())
}
object VdmAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.VdmAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.VdmAttributes =
      zio.aws.sesv2.model.VdmAttributes(
        vdmEnabled,
        dashboardAttributes.map(value => value.asEditable),
        guardianAttributes.map(value => value.asEditable)
      )
    def vdmEnabled: zio.aws.sesv2.model.FeatureStatus
    def dashboardAttributes
        : Optional[zio.aws.sesv2.model.DashboardAttributes.ReadOnly]
    def guardianAttributes
        : Optional[zio.aws.sesv2.model.GuardianAttributes.ReadOnly]
    def getVdmEnabled: ZIO[Any, Nothing, zio.aws.sesv2.model.FeatureStatus] =
      ZIO.succeed(vdmEnabled)
    def getDashboardAttributes
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DashboardAttributes.ReadOnly] =
      AwsError.unwrapOptionField("dashboardAttributes", dashboardAttributes)
    def getGuardianAttributes
        : ZIO[Any, AwsError, zio.aws.sesv2.model.GuardianAttributes.ReadOnly] =
      AwsError.unwrapOptionField("guardianAttributes", guardianAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.VdmAttributes
  ) extends zio.aws.sesv2.model.VdmAttributes.ReadOnly {
    override val vdmEnabled: zio.aws.sesv2.model.FeatureStatus =
      zio.aws.sesv2.model.FeatureStatus.wrap(impl.vdmEnabled())
    override val dashboardAttributes
        : Optional[zio.aws.sesv2.model.DashboardAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dashboardAttributes())
        .map(value => zio.aws.sesv2.model.DashboardAttributes.wrap(value))
    override val guardianAttributes
        : Optional[zio.aws.sesv2.model.GuardianAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.guardianAttributes())
        .map(value => zio.aws.sesv2.model.GuardianAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.VdmAttributes
  ): zio.aws.sesv2.model.VdmAttributes.ReadOnly = new Wrapper(impl)
}
