package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EventDestinationName,
  ConfigurationSetName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationSetEventDestinationRequest(
    configurationSetName: ConfigurationSetName,
    eventDestinationName: EventDestinationName,
    eventDestination: zio.aws.sesv2.model.EventDestinationDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest = {
    import UpdateConfigurationSetEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .eventDestinationName(
        EventDestinationName.unwrap(eventDestinationName): java.lang.String
      )
      .eventDestination(eventDestination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationRequest.ReadOnly =
    zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationRequest
      .wrap(buildAwsValue())
}
object UpdateConfigurationSetEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationRequest =
      zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationRequest(
        configurationSetName,
        eventDestinationName,
        eventDestination.asEditable
      )
    def configurationSetName: ConfigurationSetName
    def eventDestinationName: EventDestinationName
    def eventDestination
        : zio.aws.sesv2.model.EventDestinationDefinition.ReadOnly
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEventDestinationName: ZIO[Any, Nothing, EventDestinationName] =
      ZIO.succeed(eventDestinationName)
    def getEventDestination: ZIO[
      Any,
      Nothing,
      zio.aws.sesv2.model.EventDestinationDefinition.ReadOnly
    ] = ZIO.succeed(eventDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest
  ) extends zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val eventDestinationName: EventDestinationName =
      zio.aws.sesv2.model.primitives
        .EventDestinationName(impl.eventDestinationName())
    override val eventDestination
        : zio.aws.sesv2.model.EventDestinationDefinition.ReadOnly =
      zio.aws.sesv2.model.EventDestinationDefinition
        .wrap(impl.eventDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest
  ): zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
